/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.impl.EntityType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class ManyToOneType
extends EntityType {
    public ManyToOneType(org.hibernate.type.ManyToOneType type, TypeTranslator typeTranslator) {
        super((org.hibernate.type.EntityType)type, typeTranslator);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String name, SessionImplementor session, Object owner) throws HibernateException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, boolean[] settable, SessionImplementor session) throws HibernateException {
        GridType idGridType = this.getIdGridType(session.getFactory());
        idGridType.nullSafeSet(resultset, this.getIdentifier(value, session), names, settable, session);
    }

    private GridType getIdGridType(SessionFactoryImplementor sessionFactory) {
        Type idType = this.delegate.getIdentifierOrUniqueKeyType((Mapping)sessionFactory);
        GridType idGridType = this.typeTranslator.getType(idType);
        return idGridType;
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, SessionImplementor session) throws HibernateException {
        GridType idGridType = this.getIdGridType(session.getFactory());
        idGridType.nullSafeSet(resultset, this.getIdentifier(value, session), names, session);
    }

    @Override
    public Object hydrate(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdGridType(session.getFactory()).nullSafeGet(rs, names, session, null);
        this.scheduleBatchLoadIfNeeded(id, session);
        return id;
    }

    private void scheduleBatchLoadIfNeeded(Serializable id, SessionImplementor session) throws MappingException {
        if (StringHelper.isEmpty(this.delegate.getRHSUniqueKeyPropertyName()) && id != null) {
            EntityPersister persister = session.getFactory().getEntityPersister(this.delegate.getAssociatedEntityName());
            EntityKey entityKey = session.generateEntityKey(id, persister);
            if (!session.getPersistenceContext().containsEntity(entityKey)) {
                session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
            }
        }
    }
}

