/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.query.impl.LegacyParserBridgeQueryTranslator;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.spi.SearchIntegrator;

public class FullTextSearchQueryTranslator
extends LegacyParserBridgeQueryTranslator {
    private final SessionFactoryEntityNamesResolver entityNamesResolver;
    private final ConcurrentMap<CacheKey, LuceneQueryParsingResult> luceneQueryCache;

    public FullTextSearchQueryTranslator(SessionFactoryImplementor sessionFactory, String queryIdentifier, String query, Map<?, ?> filters) {
        super(sessionFactory, queryIdentifier, query, filters);
        this.entityNamesResolver = new SessionFactoryEntityNamesResolver((SessionFactory)sessionFactory);
        this.luceneQueryCache = new BoundedConcurrentHashMap(100, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    @Override
    public void doCompile(Map replacements, boolean shallow) throws QueryException, MappingException {
    }

    public List<?> list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)((Session)session));
        LuceneQueryParsingResult parsingResult = this.getLuceneQuery(queryParameters, fullTextSession);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(parsingResult.getQuery(), new Class[]{parsingResult.getTargetEntity()});
        if (this.requiresProjections(parsingResult.getProjections())) {
            fullTextQuery.setProjection(parsingResult.getProjections().toArray(new String[parsingResult.getProjections().size()]));
        }
        fullTextQuery.setSort(parsingResult.getSort());
        if (queryParameters.getRowSelection().getFirstRow() != null) {
            fullTextQuery.setFirstResult(queryParameters.getRowSelection().getFirstRow().intValue());
        }
        if (queryParameters.getRowSelection().getMaxRows() != null) {
            fullTextQuery.setMaxResults(queryParameters.getRowSelection().getMaxRows().intValue());
        }
        return fullTextQuery.list();
    }

    private LuceneQueryParsingResult getLuceneQuery(QueryParameters queryParameters, FullTextSession fullTextSession) {
        LuceneQueryParsingResult cached;
        CacheKey cacheKey = new CacheKey(queryParameters.getNamedParameters());
        LuceneQueryParsingResult parsingResult = (LuceneQueryParsingResult)this.luceneQueryCache.get(cacheKey);
        if (parsingResult == null && (cached = this.luceneQueryCache.putIfAbsent(cacheKey, parsingResult = (LuceneQueryParsingResult)new QueryParser().parseQuery(this.getQueryString(), (AstProcessingChain)this.createProcessingChain(this.getNamedParameterValues(queryParameters), fullTextSession)))) != null) {
            parsingResult = cached;
        }
        return parsingResult;
    }

    public Iterator<?> iterate(QueryParameters queryParameters, EventSource session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private boolean requiresProjections(List<String> projections) {
        if (projections.size() == 0) {
            return false;
        }
        return projections.size() != 1 || !"__HSearch_This".equals(projections.get(0));
    }

    private LuceneProcessingChain createProcessingChain(Map<String, Object> namedParameters, FullTextSession fullTextSession) {
        SearchIntegrator searchFactory = (SearchIntegrator)fullTextSession.getSearchFactory().unwrap(SearchIntegrator.class);
        return new LuceneProcessingChain.Builder(searchFactory, (EntityNamesResolver)this.entityNamesResolver).namedParameters(namedParameters).buildProcessingChainForClassBasedEntities();
    }

    private Map<String, Object> getNamedParameterValues(QueryParameters queryParameters) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            parameterValues.put((String)parameter.getKey(), ((TypedValue)parameter.getValue()).getValue());
        }
        return parameterValues;
    }

    private static class CacheKey {
        private final Map<String, TypedValue> parameters;
        private final int hashCode;

        public CacheKey(Map<String, TypedValue> parameters) {
            this.parameters = Collections.unmodifiableMap(parameters);
            this.hashCode = parameters.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }
    }
}

