/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.ogm.persister.impl.EntityDiscriminator;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class TablePerClassDiscriminator
implements EntityDiscriminator {
    private static final String DISCRIMINATOR_ALIAS = "clazz_";
    private final Integer subclassId;
    private final Map<Object, String> subclassesByValue;

    public TablePerClassDiscriminator(PersistentClass persistentClass) {
        this.subclassId = persistentClass.getSubclassId();
        this.subclassesByValue = TablePerClassDiscriminator.subclassesByValue(persistentClass, this.subclassId);
    }

    private static Map<Object, String> subclassesByValue(PersistentClass persistentClass, Object value) {
        HashMap<Object, String> subclassesByDiscriminator = new HashMap<Object, String>();
        subclassesByDiscriminator.put(persistentClass.getSubclassId(), persistentClass.getEntityName());
        if (persistentClass.isPolymorphic()) {
            Iterator iter = persistentClass.getSubclassIterator();
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                subclassesByDiscriminator.put(sc.getSubclassId(), sc.getEntityName());
            }
        }
        return subclassesByDiscriminator;
    }

    @Override
    public Object getValue() {
        return this.subclassId;
    }

    @Override
    public boolean isNeeded() {
        return false;
    }

    @Override
    public String provideClassByValue(Object value) {
        return this.subclassesByValue.get(value);
    }

    @Override
    public String getSqlValue() {
        return null;
    }

    @Override
    public String getColumnName() {
        return null;
    }

    @Override
    public String getAlias() {
        return DISCRIMINATOR_ALIAS;
    }

    @Override
    public Type getType() {
        return StandardBasicTypes.INTEGER;
    }

    @Override
    public boolean isForced() {
        return false;
    }
}

