/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.entity.impl;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.ogm.loader.entity.impl.BatchableEntityLoader;
import org.hibernate.ogm.loader.entity.impl.DynamicBatchingEntityLoaderBuilder;
import org.hibernate.ogm.loader.impl.TupleBasedEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;

public abstract class BatchingEntityLoaderBuilder {
    public static BatchingEntityLoaderBuilder getBuilder(SessionFactoryImplementor factory) {
        return DynamicBatchingEntityLoaderBuilder.INSTANCE;
    }

    public UniqueEntityLoader buildLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        if (batchSize <= 1) {
            return this.buildNonBatchingLoader(persister, lockMode, factory, influencers, innerEntityLoaderBuilder);
        }
        return this.buildBatchingLoader(persister, batchSize, lockMode, factory, influencers, innerEntityLoaderBuilder);
    }

    public UniqueEntityLoader buildLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return this.buildLoader(persister, batchSize, lockMode, factory, influencers, null);
    }

    protected UniqueEntityLoader buildNonBatchingLoader(OuterJoinLoadable persister, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        return innerEntityLoaderBuilder.buildLoader(persister, 1, lockMode, factory, influencers);
    }

    protected abstract UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable var1, int var2, LockMode var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5, BatchableEntityLoaderBuilder var6);

    public UniqueEntityLoader buildLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        if (batchSize <= 1) {
            return this.buildNonBatchingLoader(persister, lockOptions, factory, influencers, innerEntityLoaderBuilder);
        }
        return this.buildBatchingLoader(persister, batchSize, lockOptions, factory, influencers, innerEntityLoaderBuilder);
    }

    protected UniqueEntityLoader buildNonBatchingLoader(OuterJoinLoadable persister, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers, BatchableEntityLoaderBuilder innerEntityLoaderBuilder) {
        return innerEntityLoaderBuilder.buildLoader(persister, 1, lockOptions, factory, influencers);
    }

    protected abstract UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable var1, int var2, LockOptions var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5, BatchableEntityLoaderBuilder var6);

    public static interface BatchableEntityLoaderBuilder {
        public <L extends BatchableEntityLoader & TupleBasedEntityLoader> L buildLoader(OuterJoinLoadable var1, int var2, LockMode var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);

        public <L extends BatchableEntityLoader & TupleBasedEntityLoader> L buildLoader(OuterJoinLoadable var1, int var2, LockOptions var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);

        public BatchableEntityLoader buildDynamicLoader(OuterJoinLoadable var1, int var2, LockMode var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);

        public BatchableEntityLoader buildDynamicLoader(OuterJoinLoadable var1, int var2, LockOptions var3, SessionFactoryImplementor var4, LoadQueryInfluencers var5);
    }
}

