/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.collector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocIdSetBuilder;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.impl.lucene.legacy.AbstractIndexHits;
import org.neo4j.index.impl.lucene.legacy.EmptyIndexHits;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

public class DocValuesCollector
extends SimpleCollector {
    private static final EmptyIndexHits<Document> EMPTY_INDEX_HITS = new EmptyIndexHits();
    private LeafReaderContext context;
    private int segmentHits;
    private int totalHits;
    private Scorer scorer;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private Docs docs;

    public DocValuesCollector() {
        this(false);
    }

    public DocValuesCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public LongValuesIterator getValuesIterator(String field) {
        return new LongValuesIterator(this.getMatchingDocs(), this.getTotalHits(), field);
    }

    public ValuesIterator getSortedValuesIterator(String field, Sort sort) throws IOException {
        if (sort == null || sort == Sort.INDEXORDER) {
            return this.getValuesIterator(field);
        }
        int size = this.getTotalHits();
        if (size == 0) {
            return ValuesIterator.EMPTY;
        }
        TopDocs topDocs = this.getTopDocs(sort, size);
        LeafReaderContext[] contexts = DocValuesCollector.getLeafReaderContexts(this.getMatchingDocs());
        return new TopDocsValuesIterator(topDocs, contexts, field);
    }

    public IndexHits<Document> getIndexHits(Sort sort) throws IOException {
        List<MatchingDocs> matchingDocs = this.getMatchingDocs();
        int size = this.getTotalHits();
        if (size == 0) {
            return EMPTY_INDEX_HITS;
        }
        if (sort == null || sort == Sort.INDEXORDER) {
            return new DocsInIndexOrderIterator(matchingDocs, size, this.isKeepScores());
        }
        TopDocs topDocs = this.getTopDocs(sort, size);
        LeafReaderContext[] contexts = DocValuesCollector.getLeafReaderContexts(matchingDocs);
        return new TopDocsIterator(topDocs, contexts);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public boolean isKeepScores() {
        return this.keepScores;
    }

    public final void collect(int doc) throws IOException {
        this.docs.addDoc(doc);
        if (this.keepScores) {
            if (this.segmentHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(this.segmentHits + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.segmentHits);
                this.scores = newScores;
            }
            this.scores[this.segmentHits] = this.scorer.score();
        }
        ++this.segmentHits;
        ++this.totalHits;
    }

    public boolean needsScores() {
        return this.keepScores;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
        }
        int maxDoc = context.reader().maxDoc();
        this.docs = this.createDocs(maxDoc);
        if (this.keepScores) {
            int initialSize = Math.min(32, maxDoc);
            this.scores = new float[initialSize];
        }
        this.segmentHits = 0;
        this.context = context;
    }

    public List<MatchingDocs> getMatchingDocs() {
        if (this.docs != null && this.segmentHits > 0) {
            this.createMatchingDocs();
            this.docs = null;
            this.scores = null;
            this.context = null;
        }
        return Collections.unmodifiableList(this.matchingDocs);
    }

    private Docs createDocs(int maxDoc) {
        return new Docs(maxDoc);
    }

    private void createMatchingDocs() {
        if (this.scores == null || this.scores.length == this.segmentHits) {
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, this.scores));
        } else {
            float[] finalScores = new float[this.segmentHits];
            System.arraycopy(this.scores, 0, finalScores, 0, this.segmentHits);
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.segmentHits, finalScores));
        }
    }

    private TopDocs getTopDocs(Sort sort, int size) throws IOException {
        TopDocs topDocs;
        if (sort == Sort.RELEVANCE) {
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)size);
            this.replayTo((Collector)collector);
            topDocs = collector.topDocs();
        } else {
            TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)size, (boolean)false, (boolean)true, (boolean)false);
            this.replayTo((Collector)collector);
            topDocs = collector.topDocs();
        }
        return topDocs;
    }

    private static LeafReaderContext[] getLeafReaderContexts(List<MatchingDocs> matchingDocs) {
        int segments = matchingDocs.size();
        LeafReaderContext[] contexts = new LeafReaderContext[segments];
        for (int i = 0; i < segments; ++i) {
            MatchingDocs matchingDoc = matchingDocs.get(i);
            contexts[i] = matchingDoc.context;
        }
        return contexts;
    }

    private void replayTo(Collector collector) throws IOException {
        for (MatchingDocs docs : this.getMatchingDocs()) {
            int doc;
            LeafCollector leafCollector = collector.getLeafCollector(docs.context);
            DocIdSetIterator idIterator = docs.docIdSet.iterator();
            ReplayingScorer scorer = this.isKeepScores() ? new ReplayingScorer(docs.scores) : new ConstantScoreScorer(null, Float.NaN, idIterator);
            leafCollector.setScorer((Scorer)scorer);
            while ((doc = idIterator.nextDoc()) != Integer.MAX_VALUE) {
                leafCollector.collect(doc);
            }
        }
    }

    private static final class TopDocsValuesIterator
    extends ValuesIterator {
        private final ScoreDocsIterator scoreDocs;
        private final String field;
        private Map<LeafReaderContext, NumericDocValues> docValuesCache;
        private Map<String, NumericDocValues> readerCache;
        private long currentValue;
        private LeafReaderContext currentContext;
        private int currentDocID;

        public TopDocsValuesIterator(TopDocs docs, LeafReaderContext[] contexts, String field) {
            super(docs.totalHits);
            this.field = field;
            this.docValuesCache = new HashMap<LeafReaderContext, NumericDocValues>(contexts.length);
            this.readerCache = new HashMap<String, NumericDocValues>();
            this.scoreDocs = new ScoreDocsIterator(docs, contexts){

                @Override
                protected void onNextDoc(int localDocID, LeafReaderContext context) {
                    readerCache.clear();
                    currentContext = context;
                    currentDocID = localDocID;
                    this.loadNextValue(context, localDocID);
                }
            };
        }

        protected boolean fetchNext() {
            if (this.scoreDocs.hasNext()) {
                this.scoreDocs.next();
                ++this.index;
                return this.currentValue != -1L && this.next(this.currentValue);
            }
            return false;
        }

        @Override
        public long current() {
            return this.index;
        }

        @Override
        public long getValue(String field) {
            NumericDocValues fieldValues = this.readerCache.computeIfAbsent(field, this::getDocValues);
            return fieldValues.get(this.currentDocID);
        }

        private NumericDocValues getDocValues(String field) {
            try {
                return this.currentContext.reader().getNumericDocValues(field);
            }
            catch (IOException e) {
                throw new RuntimeException("Fail to read numeric doc values field " + field + " from the document.", e);
            }
        }

        private void loadNextValue(LeafReaderContext context, int docID) {
            NumericDocValues docValues;
            if (this.docValuesCache.containsKey(context)) {
                docValues = this.docValuesCache.get(context);
            } else {
                try {
                    docValues = context.reader().getNumericDocValues(this.field);
                    this.docValuesCache.put(context, docValues);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.currentValue = docValues != null ? docValues.get(docID) : -1L;
        }
    }

    private static final class TopDocsIterator
    extends AbstractIndexHits<Document> {
        private final int size;
        private final ScoreDocsIterator scoreDocs;
        private Document currentDoc;

        private TopDocsIterator(TopDocs docs, LeafReaderContext[] contexts) {
            this.scoreDocs = new ScoreDocsIterator(docs, contexts){

                @Override
                protected void onNextDoc(int localDocID, LeafReaderContext context) {
                    this.updateCurrentDocument(localDocID, context.reader());
                }
            };
            this.size = docs.scoreDocs.length;
        }

        public int size() {
            return this.size;
        }

        public float currentScore() {
            return this.scoreDocs.getCurrentDoc().score;
        }

        protected Document fetchNextOrNull() {
            if (!this.scoreDocs.hasNext()) {
                return null;
            }
            this.scoreDocs.next();
            return this.currentDoc;
        }

        private void updateCurrentDocument(int docID, LeafReader reader) {
            try {
                this.currentDoc = reader.document(docID);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class ScoreDocsIterator
    extends PrefetchingIterator<ScoreDoc> {
        private final Iterator<ScoreDoc> iterator;
        private final int[] docStarts;
        private final LeafReaderContext[] contexts;
        protected ScoreDoc currentDoc;

        private ScoreDocsIterator(TopDocs docs, LeafReaderContext[] contexts) {
            this.contexts = contexts;
            this.iterator = new ArrayIterator((Object[])docs.scoreDocs);
            int segments = contexts.length;
            this.docStarts = new int[segments + 1];
            for (int i = 0; i < segments; ++i) {
                LeafReaderContext context = contexts[i];
                this.docStarts[i] = context.docBase;
            }
            LeafReaderContext lastContext = contexts[segments - 1];
            this.docStarts[segments] = lastContext.docBase + lastContext.reader().maxDoc();
        }

        public ScoreDoc getCurrentDoc() {
            return this.currentDoc;
        }

        protected ScoreDoc fetchNextOrNull() {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.currentDoc = this.iterator.next();
            int subIndex = ReaderUtil.subIndex((int)this.currentDoc.doc, (int[])this.docStarts);
            LeafReaderContext context = this.contexts[subIndex];
            this.onNextDoc(this.currentDoc.doc - context.docBase, context);
            return this.currentDoc;
        }

        protected abstract void onNextDoc(int var1, LeafReaderContext var2);
    }

    private static final class DocsInIndexOrderIterator
    extends AbstractIndexHits<Document> {
        private final Iterator<MatchingDocs> docs;
        private final int size;
        private final boolean keepScores;
        private DocIdSetIterator currentIdIterator;
        private Scorer currentScorer;
        private LeafReader currentReader;

        private DocsInIndexOrderIterator(List<MatchingDocs> docs, int size, boolean keepScores) {
            this.size = size;
            this.keepScores = keepScores;
            this.docs = docs.iterator();
        }

        public int size() {
            return this.size;
        }

        public float currentScore() {
            try {
                return this.currentScorer.score();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected Document fetchNextOrNull() {
            if (this.ensureValidDisi()) {
                try {
                    int doc = this.currentIdIterator.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        this.currentIdIterator = null;
                        this.currentScorer = null;
                        this.currentReader = null;
                        return this.fetchNextOrNull();
                    }
                    return this.currentReader.document(doc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        private boolean ensureValidDisi() {
            while (this.currentIdIterator == null && this.docs.hasNext()) {
                MatchingDocs matchingDocs = this.docs.next();
                try {
                    this.currentIdIterator = matchingDocs.docIdSet.iterator();
                    this.currentScorer = this.keepScores ? new ReplayingScorer(matchingDocs.scores) : new ConstantScoreScorer(null, Float.NaN, this.currentIdIterator);
                    this.currentReader = matchingDocs.context.reader();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.currentIdIterator != null;
        }
    }

    private static class ReplayingScorer
    extends Scorer {
        private final float[] scores;
        private int index = 0;

        public ReplayingScorer(float[] scores) {
            super(null);
            this.scores = scores;
        }

        public float score() throws IOException {
            if (this.index < this.scores.length) {
                return this.scores[this.index++];
            }
            return Float.NaN;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Docs {
        private final DocIdSetBuilder bits;

        public Docs(int maxDoc) {
            this.bits = new DocIdSetBuilder(maxDoc);
        }

        public void addDoc(int docId) {
            this.bits.add(docId);
        }

        public DocIdSet getDocIdSet() {
            return this.bits.build();
        }
    }

    static final class MatchingDocs {
        public final LeafReaderContext context;
        public final DocIdSet docIdSet;
        public final float[] scores;
        public final int totalHits;

        public MatchingDocs(LeafReaderContext context, DocIdSet docIdSet, int totalHits, float[] scores) {
            this.context = context;
            this.docIdSet = docIdSet;
            this.totalHits = totalHits;
            this.scores = scores;
        }

        public NumericDocValues readDocValues(String field) {
            try {
                NumericDocValues dv = this.context.reader().getNumericDocValues(field);
                if (dv == null) {
                    FieldInfo fi = this.context.reader().getFieldInfos().fieldInfo(field);
                    DocValuesType actual = null;
                    if (fi != null) {
                        actual = fi.getDocValuesType();
                    }
                    throw new IllegalStateException("The field '" + field + "' is not indexed properly, expected NumericDV, but got '" + actual + "'");
                }
                return dv;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LongValuesIterator
    extends ValuesIterator {
        private final Iterator<MatchingDocs> matchingDocs;
        private final String field;
        private DocIdSetIterator currentIdIterator;
        private NumericDocValues currentDocValues;
        private MatchingDocs currentDocs;
        private final Map<String, NumericDocValues> docValuesCache;

        public LongValuesIterator(Iterable<MatchingDocs> allMatchingDocs, int totalHits, String field) {
            super(totalHits);
            this.field = field;
            this.matchingDocs = allMatchingDocs.iterator();
            this.docValuesCache = new HashMap<String, NumericDocValues>();
        }

        @Override
        public long current() {
            return this.next;
        }

        @Override
        public long getValue(String field) {
            if (this.ensureValidDisi()) {
                if (this.docValuesCache.containsKey(field)) {
                    return this.docValuesCache.get(field).get(this.currentIdIterator.docID());
                }
                NumericDocValues docValues = this.currentDocs.readDocValues(field);
                this.docValuesCache.put(field, docValues);
                return docValues.get(this.currentIdIterator.docID());
            }
            return 0L;
        }

        protected boolean fetchNext() {
            try {
                if (this.ensureValidDisi()) {
                    int nextDoc = this.currentIdIterator.nextDoc();
                    if (nextDoc != Integer.MAX_VALUE) {
                        ++this.index;
                        return this.next(this.currentDocValues.get(nextDoc));
                    }
                    this.currentIdIterator = null;
                    return this.fetchNext();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        private boolean ensureValidDisi() {
            try {
                while (this.currentIdIterator == null) {
                    if (this.matchingDocs.hasNext()) {
                        this.currentDocs = this.matchingDocs.next();
                        this.currentIdIterator = this.currentDocs.docIdSet.iterator();
                        if (this.currentIdIterator == null) continue;
                        this.docValuesCache.clear();
                        this.currentDocValues = this.currentDocs.readDocValues(this.field);
                        continue;
                    }
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

