/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktreeords.BlockTreeOrdsPostingsFormat;
import org.apache.lucene.codecs.lucene54.Lucene54Codec;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.MultipleBackupDeletionPolicy;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public final class IndexWriterConfigs {
    private static final int MAX_BUFFERED_DOCS = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"max_buffered_docs", (int)100000);
    private static final int POPULATION_MAX_BUFFERED_DOCS = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"population_max_buffered_docs", (int)-1);
    private static final int MAX_BUFFERED_DELETE_TERMS = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"max_buffered_delete_terms", (int)15000);
    private static final int MERGE_POLICY_MERGE_FACTOR = FeatureToggles.getInteger(IndexWriterConfigs.class, (String)"merge.factor", (int)2);
    private static final double MERGE_POLICY_NO_CFS_RATIO = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"nocfs.ratio", (double)1.0);
    private static final double MERGE_POLICY_MIN_MERGE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"min.merge", (double)0.1);
    private static final boolean CODEC_BLOCK_TREE_ORDS_POSTING_FORMAT = FeatureToggles.flag(IndexWriterConfigs.class, (String)"block.tree.ords.posting.format", (boolean)true);
    private static final double STANDARD_RAM_BUFFER_SIZE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"standard.ram.buffer.size", (double)16.0);
    private static final double POPULATION_RAM_BUFFER_SIZE_MB = FeatureToggles.getDouble(IndexWriterConfigs.class, (String)"population.ram.buffer.size", (double)50.0);
    private static final BlockTreeOrdsPostingsFormat blockTreeOrdsPostingsFormat = new BlockTreeOrdsPostingsFormat();

    private IndexWriterConfigs() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static IndexWriterConfig standard() {
        IndexWriterConfig writerConfig = new IndexWriterConfig(LuceneDataSource.KEYWORD_ANALYZER);
        writerConfig.setMaxBufferedDocs(MAX_BUFFERED_DOCS);
        writerConfig.setMaxBufferedDeleteTerms(MAX_BUFFERED_DELETE_TERMS);
        writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
        writerConfig.setUseCompoundFile(true);
        writerConfig.setRAMBufferSizeMB(STANDARD_RAM_BUFFER_SIZE_MB);
        writerConfig.setCodec((Codec)new Lucene54Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                PostingsFormat postingFormat = super.getPostingsFormatForField(field);
                return CODEC_BLOCK_TREE_ORDS_POSTING_FORMAT ? blockTreeOrdsPostingsFormat : postingFormat;
            }
        });
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(MERGE_POLICY_NO_CFS_RATIO);
        mergePolicy.setMinMergeMB(MERGE_POLICY_MIN_MERGE_MB);
        mergePolicy.setMergeFactor(MERGE_POLICY_MERGE_FACTOR);
        writerConfig.setMergePolicy((MergePolicy)mergePolicy);
        return writerConfig;
    }

    public static IndexWriterConfig population() {
        IndexWriterConfig writerConfig = IndexWriterConfigs.standard();
        writerConfig.setMaxBufferedDocs(POPULATION_MAX_BUFFERED_DOCS);
        writerConfig.setRAMBufferSizeMB(POPULATION_RAM_BUFFER_SIZE_MB);
        return writerConfig;
    }
}

