/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class DuplicatingLog
extends AbstractLog {
    private final CopyOnWriteArraySet<Log> logs;
    private final DuplicatingLogger debugLogger;
    private final DuplicatingLogger infoLogger;
    private final DuplicatingLogger warnLogger;
    private final DuplicatingLogger errorLogger;

    public DuplicatingLog(Log ... logs) {
        this(Arrays.asList(logs));
    }

    public DuplicatingLog(List<Log> logs) {
        ArrayList<Logger> debugLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> infoLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> warnLoggers = new ArrayList<Logger>(logs.size());
        ArrayList<Logger> errorLoggers = new ArrayList<Logger>(logs.size());
        for (Log log : logs) {
            debugLoggers.add(log.debugLogger());
            infoLoggers.add(log.infoLogger());
            warnLoggers.add(log.warnLogger());
            errorLoggers.add(log.errorLogger());
        }
        this.logs = new CopyOnWriteArraySet<Log>(logs);
        this.debugLogger = new DuplicatingLogger(debugLoggers);
        this.infoLogger = new DuplicatingLogger(infoLoggers);
        this.warnLogger = new DuplicatingLogger(warnLoggers);
        this.errorLogger = new DuplicatingLogger(errorLoggers);
    }

    public boolean remove(Log log) {
        boolean removed = this.logs.remove(log);
        this.debugLogger.remove(log.debugLogger());
        this.infoLogger.remove(log.infoLogger());
        this.warnLogger.remove(log.warnLogger());
        this.errorLogger.remove(log.errorLogger());
        return removed;
    }

    @Override
    public boolean isDebugEnabled() {
        for (Log log : this.logs) {
            if (!log.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.debugLogger;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.infoLogger;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.warnLogger;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.errorLogger;
    }

    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        DuplicatingLog.bulk(new LinkedList<Log>(this.logs), new ArrayList<Log>(this.logs.size()), consumer);
    }

    private static void bulk(LinkedList<Log> remaining, ArrayList<Log> bulkLogs, Consumer<Log> finalConsumer) {
        if (!remaining.isEmpty()) {
            Log log = remaining.pop();
            log.bulk(bulkLog -> {
                bulkLogs.add((Log)bulkLog);
                DuplicatingLog.bulk(remaining, bulkLogs, finalConsumer);
            });
        } else {
            DuplicatingLog log = new DuplicatingLog(bulkLogs);
            finalConsumer.accept(log);
        }
    }

    private static class DuplicatingLogger
    implements Logger {
        private final CopyOnWriteArraySet<Logger> loggers;

        public DuplicatingLogger(List<Logger> loggers) {
            this.loggers = new CopyOnWriteArraySet<Logger>(loggers);
        }

        public boolean remove(Logger logger) {
            return this.loggers.remove(logger);
        }

        @Override
        public void log(@Nonnull String message) {
            for (Logger logger : this.loggers) {
                logger.log(message);
            }
        }

        @Override
        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            for (Logger logger : this.loggers) {
                logger.log(message, throwable);
            }
        }

        @Override
        public void log(@Nonnull String format, Object ... arguments) {
            for (Logger logger : this.loggers) {
                logger.log(format, arguments);
            }
        }

        @Override
        public void bulk(@Nonnull Consumer<Logger> consumer) {
            DuplicatingLogger.bulk(new LinkedList<Logger>(this.loggers), new ArrayList<Logger>(this.loggers.size()), consumer);
        }

        private static void bulk(LinkedList<Logger> remaining, ArrayList<Logger> bulkLoggers, Consumer<Logger> finalConsumer) {
            if (!remaining.isEmpty()) {
                Logger logger = remaining.pop();
                logger.bulk(bulkLogger -> {
                    bulkLoggers.add((Logger)bulkLogger);
                    DuplicatingLogger.bulk(remaining, bulkLoggers, finalConsumer);
                });
            } else {
                DuplicatingLogger logger = new DuplicatingLogger(bulkLoggers);
                finalConsumer.accept(logger);
            }
        }
    }
}

