/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class IteratorBatcherStep<T>
extends IoProducerStep {
    private final Iterator<T> data;
    private final Class<T> itemClass;
    protected long cursor;

    public IteratorBatcherStep(StageControl control, Configuration config, Iterator<T> data, Class<T> itemClass) {
        super(control, config);
        this.data = data;
        this.itemClass = itemClass;
    }

    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        int i;
        if (!this.data.hasNext()) {
            return null;
        }
        Object[] batch = (Object[])Array.newInstance(this.itemClass, batchSize);
        for (i = 0; i < batchSize && this.data.hasNext(); ++i) {
            batch[i] = this.data.next();
            ++this.cursor;
        }
        return i == batchSize ? batch : Arrays.copyOf(batch, i);
    }
}

