/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.function.Supplier;
import org.neo4j.cursor.Cursor;

public class ContinuableArrayCursor<T>
implements Cursor<T> {
    private final Supplier<T[]> supplier;
    private T[] current;
    private int cursor;

    public ContinuableArrayCursor(Supplier<T[]> supplier) {
        this.supplier = supplier;
    }

    public boolean next() {
        while (this.current == null || this.cursor >= this.current.length) {
            this.current = this.supplier.get();
            if (this.current == null) {
                return false;
            }
            this.cursor = 0;
        }
        ++this.cursor;
        return true;
    }

    public void close() {
    }

    public T get() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return this.current[this.cursor - 1];
    }
}

