/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LogPruningImpl
implements LogPruning {
    private final Lock pruneLock = new ReentrantLock();
    private final LogPruneStrategy pruneStrategy;
    private final Log msgLog;

    public LogPruningImpl(LogPruneStrategy pruneStrategy, LogProvider logProvider) {
        this.pruneStrategy = pruneStrategy;
        this.msgLog = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneLogs(long upToVersion) {
        if (this.pruneLock.tryLock()) {
            String prefix = "Log Rotation [" + upToVersion + "]: ";
            this.msgLog.info(prefix + " Starting log pruning.");
            try {
                this.pruneStrategy.prune(upToVersion);
            }
            finally {
                this.pruneLock.unlock();
                this.msgLog.info(prefix + " Log pruning complete.");
            }
        }
    }
}

