/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import org.neo4j.helpers.Clock;

public class RotationTimerFactory {
    private Clock clock;
    private long timeoutMillis;

    public RotationTimerFactory(Clock clock, long timeoutMillis) {
        this.clock = clock;
        this.timeoutMillis = timeoutMillis;
    }

    public RotationTimer createTimer() {
        long startTime = this.clock.currentTimeMillis();
        return new RotationTimer(startTime, startTime + this.timeoutMillis);
    }

    class RotationTimer {
        private long startTime;
        private long timeoutTime;

        public RotationTimer(long startTime, long timeoutTime) {
            this.startTime = startTime;
            this.timeoutTime = timeoutTime;
        }

        public boolean isTimedOut() {
            return RotationTimerFactory.this.clock.currentTimeMillis() > this.timeoutTime;
        }

        public long getElapsedTimeMillis() {
            return RotationTimerFactory.this.clock.currentTimeMillis() - this.startTime;
        }
    }
}

