/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.LabelItem;

public class StoreLabelCursor
implements Cursor<LabelItem>,
LabelItem {
    private long[] labels;
    private int index;
    private int currentLabel;
    private final RecordCursor<DynamicRecord> dynamicLabelRecordCursor;
    private final Consumer<StoreLabelCursor> instanceCache;

    public StoreLabelCursor(RecordCursor<DynamicRecord> dynamicLabelRecordCursor, Consumer<StoreLabelCursor> instanceCache) {
        this.dynamicLabelRecordCursor = dynamicLabelRecordCursor;
        this.instanceCache = instanceCache;
    }

    public StoreLabelCursor init(NodeRecord nodeRecord) {
        this.labels = NodeLabelsField.get(nodeRecord, this.dynamicLabelRecordCursor);
        return this;
    }

    public boolean next() {
        if (this.index < this.labels.length) {
            this.currentLabel = IoPrimitiveUtils.safeCastLongToInt(this.labels[this.index++]);
            return true;
        }
        return false;
    }

    public LabelItem get() {
        return this;
    }

    @Override
    public int getAsInt() {
        return this.currentLabel;
    }

    public void close() {
        this.clearState();
        this.instanceCache.accept(this);
    }

    private void clearState() {
        this.labels = null;
        this.index = 0;
    }
}

