/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class KernelSchemaStateStore
implements UpdateableSchemaState {
    private Map<Object, Object> state;
    private final Log log;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public KernelSchemaStateStore(LogProvider logProvider) {
        this.state = new HashMap<Object, Object>();
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public <K, V> V get(K key) {
        this.lock.readLock().lock();
        try {
            Object object = this.state.get(key);
            return (V)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> V getOrCreate(K key, Function<K, V> creator) {
        V currentValue = this.get(key);
        if (currentValue == null) {
            this.lock.writeLock().lock();
            try {
                Object lockedValue = this.state.get(key);
                if (lockedValue == null) {
                    V newValue = creator.apply(key);
                    this.state.put(key, newValue);
                    V v = newValue;
                    return v;
                }
                Object object = lockedValue;
                return (V)object;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return currentValue;
    }

    @Override
    public void replace(Map<Object, Object> replacement) {
        this.lock.writeLock().lock();
        try {
            this.state = replacement;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public <K, V> void apply(Map<K, V> updates) {
        this.lock.writeLock().lock();
        try {
            this.state.putAll(updates);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.state.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.log.info("Schema state store has been cleared.");
    }
}

