/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.neo4j.helpers.collection.Pair;

public class AnnotatedFieldHarvester {
    public <T> Iterable<Pair<Field, T>> findStatic(Class<?> clazz, Class<T> type, Class annotation) {
        ArrayList<Pair<Field, T>> found = new ArrayList<Pair<Field, T>>();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(null);
                if (!type.isInstance(fieldValue) || annotation != null && field.getAnnotation(annotation) == null) continue;
                found.add(Pair.of((Object)field, (Object)fieldValue));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Field " + clazz.getName() + "#" + field.getName() + " is not public";
            }
            catch (NullPointerException npe) {
                assert (false) : "Field " + clazz.getName() + "#" + field.getName() + " is not static";
            }
        }
        return found;
    }

    public <T> Iterable<Pair<Field, T>> findStatic(Class<?> clazz, Class<T> type) {
        return this.findStatic(clazz, type, null);
    }
}

