/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protostream;

import java.util.Map;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.ogm.datastore.infinispanremote.impl.VersionedTuple;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public final class ProtostreamPayload {
    private final MapTupleSnapshot loadedSnapshot;
    private final Tuple tuple;

    public ProtostreamPayload(MapTupleSnapshot loadedSnapshot) {
        this.loadedSnapshot = Objects.requireNonNull(loadedSnapshot);
        this.tuple = null;
    }

    public ProtostreamPayload(Tuple tuple) {
        this.tuple = Objects.requireNonNull(tuple);
        this.loadedSnapshot = null;
    }

    public Tuple toTuple(Tuple.SnapshotType snapshotType) {
        if (this.loadedSnapshot != null) {
            return new VersionedTuple((TupleSnapshot)this.loadedSnapshot, snapshotType);
        }
        this.tuple.setSnapshotType(snapshotType);
        return this.tuple;
    }

    public VersionedTuple toVersionedTuple(Tuple.SnapshotType snapshotType) {
        if (this.loadedSnapshot != null) {
            return new VersionedTuple((TupleSnapshot)this.loadedSnapshot, snapshotType);
        }
        if (this.tuple instanceof VersionedTuple) {
            VersionedTuple vt = (VersionedTuple)this.tuple;
            vt.setSnapshotType(snapshotType);
            return vt;
        }
        throw new AssertionFailure("toVersionedTuple() can only be used on just loaded instances");
    }

    public Object getColumnValue(String columnName) {
        if (this.tuple != null) {
            return this.tuple.get(columnName);
        }
        return this.loadedSnapshot.get(columnName);
    }

    public Map<String, Object> toMap() {
        if (this.loadedSnapshot != null) {
            return this.loadedSnapshot.getMap();
        }
        MapTupleSnapshot tupleSnapshot = (MapTupleSnapshot)this.tuple.getSnapshot();
        return tupleSnapshot.getMap();
    }

    public RowKey asRowKey(AssociationKey key) {
        String[] columnNames = key.getMetadata().getRowKeyColumnNames();
        Object[] columnValues = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            columnValues[i] = this.getColumnValue(columnName);
        }
        return new RowKey(columnNames, columnValues);
    }
}

