/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl.protobuf;

import java.io.IOException;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.ProtofieldAccessor;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.TypeDeclarationsCollector;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.TypeDefinition;
import org.infinispan.protostream.MessageMarshaller;

public class EnumProtofieldAccessor
implements ProtofieldAccessor<Enum> {
    private final int tag;
    private final String name;
    private final Class<? extends Enum> type;
    private final String columnName;
    private final boolean nullable;

    public EnumProtofieldAccessor(int tag, String name, boolean nullable, Class<? extends Enum> type, String columnName) {
        this.tag = tag;
        this.name = name;
        this.nullable = nullable;
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter outProtobuf, Enum value) throws IOException {
        outProtobuf.writeObject(this.name, (Object)value, this.type);
    }

    @Override
    public Enum read(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        return (Enum)reader.readObject(this.name, this.type);
    }

    @Override
    public void collectTypeDefinitions(TypeDeclarationsCollector typesDefCollector) {
        typesDefCollector.createTypeDefinition(new EnumTypeDefinition(this.type));
    }

    @Override
    public void exportProtobufFieldDefinition(StringBuilder sb) {
        if (this.nullable) {
            sb.append("\n\toptional ");
        } else {
            sb.append("\n\trequired ");
        }
        sb.append(this.type.getSimpleName());
        sb.append(" ");
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.tag);
        sb.append(";");
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getProtobufName() {
        return this.name;
    }

    private static final class EnumTypeDefinition
    implements TypeDefinition {
        private final Class<? extends Enum> type;

        public EnumTypeDefinition(Class<? extends Enum> type) {
            if (type == null) {
                throw new NullPointerException("The 'type' parameter shall not be null");
            }
            this.type = type;
        }

        @Override
        public void exportProtobufTypeDefinition(StringBuilder sb) {
            Enum[] enumConstants = this.type.getEnumConstants();
            sb.append("\nenum ");
            sb.append(this.type.getSimpleName());
            sb.append(" {");
            for (int i = 0; i < enumConstants.length; ++i) {
                sb.append("\n\t");
                sb.append(enumConstants[i].name());
                sb.append(" = ");
                sb.append(i);
                sb.append(";");
            }
            sb.append("\n}\n");
        }

        @Override
        public String getTypeName() {
            return this.type.getSimpleName();
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (EnumTypeDefinition.class != obj.getClass()) {
                return false;
            }
            EnumTypeDefinition other = (EnumTypeDefinition)obj;
            return this.type.equals(other.type);
        }
    }
}

