/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.impl;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.ogm.datastore.infinispanremote.InfinispanRemoteDialect;
import org.hibernate.ogm.datastore.infinispanremote.configuration.impl.InfinispanRemoteConfiguration;
import org.hibernate.ogm.datastore.infinispanremote.impl.HotRodClientBuilder;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtoStreamMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtobufSchemaInitializer;
import org.hibernate.ogm.datastore.infinispanremote.impl.ProtostreamAssociationMappingAdapter;
import org.hibernate.ogm.datastore.infinispanremote.impl.protobuf.SchemaDefinitions;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.OgmProtoStreamMarshaller;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtoDataMapper;
import org.hibernate.ogm.datastore.infinispanremote.impl.protostream.ProtostreamSerializerSetup;
import org.hibernate.ogm.datastore.infinispanremote.impl.schema.SequenceTableDefinition;
import org.hibernate.ogm.datastore.infinispanremote.impl.sequences.HotRodSequenceHandler;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispanremote.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaCapture;
import org.hibernate.ogm.datastore.infinispanremote.schema.spi.SchemaOverride;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.protostream.SerializationContext;

public class InfinispanRemoteDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.getLogger();
    private final OgmProtoStreamMarshaller marshaller = new OgmProtoStreamMarshaller();
    private InfinispanRemoteConfiguration config;
    private RemoteCacheManager hotrodClient;
    private SchemaCapture schemaCapture;
    private ServiceRegistryImplementor serviceRegistry;
    private SchemaOverride schemaOverrideService;
    private Set<String> mappedCacheNames;
    private Map<String, ProtoDataMapper> perCacheSchemaMappers;
    private HotRodSequenceHandler sequences;
    private SchemaDefinitions sd;
    private String schemaPackageName;

    public Class<? extends GridDialect> getDefaultDialect() {
        return InfinispanRemoteDialect.class;
    }

    public void start() {
        this.hotrodClient = HotRodClientBuilder.builder().withConfiguration(this.config, this.marshaller).build();
        this.hotrodClient.start();
        this.config = null;
    }

    public RemoteCacheManager getRemoteCacheManager() {
        return this.hotrodClient;
    }

    public void stop() {
        this.hotrodClient.stop();
    }

    public void configure(Map configurationValues) {
        this.config = new InfinispanRemoteConfiguration();
        this.config.initConfiguration(configurationValues, this.serviceRegistry);
        this.schemaCapture = this.config.getSchemaCaptureService();
        this.schemaOverrideService = this.config.getSchemaOverrideService();
        this.schemaPackageName = this.config.getSchemaPackageName();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return ProtobufSchemaInitializer.class;
    }

    public void registerSchemaDefinitions(SchemaDefinitions sd) {
        this.sd = sd;
        sd.validateSchema();
        RemoteCache<String, String> protobufCache = this.getProtobufCache();
        String generatedProtobufName = "Hibernate_OGM_Generated_schema.proto";
        sd.deploySchema("Hibernate_OGM_Generated_schema.proto", protobufCache, this.schemaCapture, this.schemaOverrideService);
        this.sequences = new HotRodSequenceHandler(this, this.marshaller, sd.getSequenceDefinitions());
        this.setMappedCacheNames(sd);
        this.startAndValidateCaches();
        this.perCacheSchemaMappers = sd.generateSchemaMappingAdapters(this, sd, this.marshaller);
    }

    private void startAndValidateCaches() {
        TreeSet<String> failedCacheNames = new TreeSet<String>();
        this.mappedCacheNames.forEach(cacheName -> {
            RemoteCache cache = this.hotrodClient.getCache(cacheName);
            if (cache == null) {
                failedCacheNames.add((String)cacheName);
            }
        });
        if (failedCacheNames.size() > 1) {
            throw log.expectedCachesNotDefined(failedCacheNames);
        }
        if (failedCacheNames.size() == 1) {
            throw log.expectedCacheNotDefined((String)failedCacheNames.iterator().next());
        }
    }

    private void setMappedCacheNames(SchemaDefinitions sd) {
        this.mappedCacheNames = sd.getTableNames();
    }

    private RemoteCache<String, String> getProtobufCache() {
        return this.getCache("___protobuf_metadata");
    }

    public boolean allowsTransactionEmulation() {
        return true;
    }

    public String getProtobufPackageName() {
        return this.schemaPackageName;
    }

    public Set<String> getMappedCacheNames() {
        return this.mappedCacheNames;
    }

    public ProtoStreamMappingAdapter getDataMapperForCache(String cacheName) {
        return this.perCacheSchemaMappers.get(cacheName);
    }

    public ProtostreamAssociationMappingAdapter getCollectionsDataMapper(String cacheName) {
        return this.perCacheSchemaMappers.get(cacheName);
    }

    public HotRodSequenceHandler getSequenceHandler() {
        return this.sequences;
    }

    public SerializationContext getSerializationContextForSequences(SequenceTableDefinition std) {
        return ProtostreamSerializerSetup.buildSerializationContextForSequences(this.sd, std);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        RemoteCache cache = this.hotrodClient.getCache(cacheName);
        if (cache == null) {
            throw log.expectedCacheNotDefined(cacheName);
        }
        return cache;
    }
}

