/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiSet<T> {
    private final Map<T, Long> inner;
    private int size = 0;

    public MultiSet() {
        this.inner = new HashMap<T, Long>();
    }

    public MultiSet(int initialCapacity) {
        this.inner = new HashMap<T, Long>(initialCapacity);
    }

    public boolean contains(T value) {
        return this.inner.containsKey(value);
    }

    public long count(T value) {
        return this.unbox(this.inner.get(value));
    }

    public long add(T value) {
        return this.increment(value, 1L);
    }

    public long remove(T value) {
        return this.increment(value, -1L);
    }

    public long replace(T value, long newCount) {
        if (newCount <= 0L) {
            long previous = this.unbox(this.inner.remove(value));
            this.size = (int)((long)this.size - previous);
            return previous;
        }
        long previous = this.unbox(this.inner.put(value, newCount));
        this.size = (int)((long)this.size + (newCount - previous));
        return previous;
    }

    public long increment(T value, long amount) {
        long previous = this.count(value);
        if (amount == 0L) {
            return previous;
        }
        long newCount = previous + amount;
        if (newCount <= 0L) {
            this.inner.remove(value);
            this.size = (int)((long)this.size - previous);
            return 0L;
        }
        this.inner.put(value, newCount);
        this.size = (int)((long)this.size + amount);
        return newCount;
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public int size() {
        return this.size;
    }

    public int uniqueSize() {
        return this.inner.size();
    }

    public void clear() {
        this.inner.clear();
        this.size = 0;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.inner.equals(((MultiSet)other).inner);
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    private long unbox(Long value) {
        return value == null ? 0L : value;
    }

    public Set<Map.Entry<T, Long>> entrySet() {
        return this.inner.entrySet();
    }
}

