/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.options;

import com.mongodb.MongoCredential;

public enum AuthenticationMechanismType {
    GSSAPI{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createGSSAPICredential((String)username);
        }
    }
    ,
    MONGODB_CR{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createMongoCRCredential((String)username, (String)databaseName, (char[])AuthenticationMechanismType.asCharArray(password));
        }
    }
    ,
    PLAIN{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createPlainCredential((String)username, (String)databaseName, (char[])AuthenticationMechanismType.asCharArray(password));
        }
    }
    ,
    MONGODB_X509{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createMongoX509Credential((String)username);
        }
    }
    ,
    SCRAM_SHA_1{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createScramSha1Credential((String)username, (String)databaseName, (char[])AuthenticationMechanismType.asCharArray(password));
        }
    }
    ,
    BEST{

        @Override
        public MongoCredential createCredential(String username, String databaseName, String password) {
            return MongoCredential.createCredential((String)username, (String)databaseName, (char[])AuthenticationMechanismType.asCharArray(password));
        }
    };


    private static char[] asCharArray(String password) {
        if (password == null) {
            return null;
        }
        return password.toCharArray();
    }

    public abstract MongoCredential createCredential(String var1, String var2, String var3);
}

