/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.configuration.impl;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.cfg.spi.DocumentStoreConfiguration;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AuthenticationMechanismType;
import org.hibernate.ogm.datastore.mongodb.options.impl.ReadPreferenceOption;
import org.hibernate.ogm.datastore.mongodb.options.impl.WriteConcernOption;
import org.hibernate.ogm.options.spi.OptionsContext;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;

public class MongoDBConfiguration
extends DocumentStoreConfiguration {
    public static final String DEFAULT_ASSOCIATION_STORE = "Associations";
    private static final int DEFAULT_PORT = 27017;
    private static final Log log = LoggerFactory.getLogger();
    private final WriteConcern writeConcern;
    private final ReadPreference readPreference;
    private final AuthenticationMechanismType authenticationMechanism;
    private final ConfigurationPropertyReader propertyReader;

    public MongoDBConfiguration(ConfigurationPropertyReader propertyReader, OptionsContext globalOptions) {
        super(propertyReader, 27017);
        this.propertyReader = propertyReader;
        this.authenticationMechanism = (AuthenticationMechanismType)((Object)propertyReader.property("hibernate.ogm.mongodb.authentication_mechanism", AuthenticationMechanismType.class).withDefault((Object)AuthenticationMechanismType.BEST).getValue());
        this.writeConcern = (WriteConcern)globalOptions.getUnique(WriteConcernOption.class);
        this.readPreference = (ReadPreference)globalOptions.getUnique(ReadPreferenceOption.class);
    }

    public MongoClientOptions buildOptions() {
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        optionsBuilder.writeConcern(this.writeConcern);
        optionsBuilder.readPreference(this.readPreference);
        Map<String, Method> settingsMap = this.createSettingsMap();
        for (Map.Entry<String, Method> entry : settingsMap.entrySet()) {
            Object property;
            String setting = "hibernate.ogm.mongodb.driver." + entry.getKey();
            Class<Object> type = entry.getValue().getParameterTypes()[0];
            if (Integer.TYPE.equals(type)) {
                type = Integer.class;
            }
            if (Boolean.TYPE.equals(type)) {
                type = Boolean.class;
            }
            if ((property = this.propertyReader.property(setting, type).withDefault(null).getValue()) == null) continue;
            Method settingMethod = entry.getValue();
            try {
                settingMethod.invoke((Object)optionsBuilder, property);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw log.unableToInvokeMethodViaReflection(settingMethod.getDeclaringClass().getName(), settingMethod.getName());
            }
        }
        return optionsBuilder.build();
    }

    private Map<String, Method> createSettingsMap() {
        Method[] methods;
        HashMap<String, Method> settingsMap = new HashMap<String, Method>();
        for (Method method : methods = MongoClientOptions.Builder.class.getDeclaredMethods()) {
            Class<?> parameterType;
            if (method.getParameterTypes().length != 1 || !String.class.equals(parameterType = method.getParameterTypes()[0]) && !Integer.TYPE.equals(parameterType) && !Boolean.TYPE.equals(parameterType)) continue;
            settingsMap.put(method.getName(), method);
        }
        return settingsMap;
    }

    public List<MongoCredential> buildCredentials() {
        if (this.getUsername() != null) {
            return Collections.singletonList(this.authenticationMechanism.createCredential(this.getUsername(), this.getDatabaseName(), this.getPassword()));
        }
        return null;
    }
}

