/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class LuceneSchemaIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    static final String KEY = "lucene";
    public static final SchemaIndexProvider.Descriptor PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("lucene", "1.0");
    private static final Function<Class<DirectoryFactory>, DirectoryFactory> IN_MEMORY_FACTORY = new Function<Class<DirectoryFactory>, DirectoryFactory>(){

        public DirectoryFactory apply(Class<DirectoryFactory> directoryFactoryClass) {
            return new DirectoryFactory.InMemoryDirectoryFactory();
        }
    };

    public LuceneSchemaIndexProviderFactory() {
        super(KEY);
    }

    public LuceneSchemaIndexProvider newKernelExtension(Dependencies dependencies) throws Throwable {
        return new LuceneSchemaIndexProvider(this.directoryFactory(dependencies), dependencies.getConfig());
    }

    private DirectoryFactory directoryFactory(Dependencies dependencies) {
        FileSystemAbstraction fileSystem = dependencies.getFileSystem();
        if (((Boolean)dependencies.getConfig().get(InternalAbstractGraphDatabase.Configuration.ephemeral)).booleanValue()) {
            return (DirectoryFactory)fileSystem.getOrCreateThirdPartyFileSystem(DirectoryFactory.class, IN_MEMORY_FACTORY);
        }
        return (DirectoryFactory)fileSystem.getOrCreateThirdPartyFileSystem(DirectoryFactory.class, Functions.constant((Object)DirectoryFactory.PERSISTENT));
    }

    public static interface Dependencies {
        public Config getConfig();

        public FileSystemAbstraction getFileSystem();
    }
}

