/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.DirectorySupport;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.IndexPopulator;

public abstract class LuceneIndexPopulator
implements IndexPopulator {
    protected final LuceneDocumentStructure documentStructure;
    private final LuceneIndexWriterFactory indexWriterFactory;
    private final IndexWriterStatus writerStatus;
    private final DirectoryFactory dirFactory;
    private final File dirFile;
    protected IndexWriter writer;
    private Directory directory;

    LuceneIndexPopulator(LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) {
        this.documentStructure = documentStructure;
        this.indexWriterFactory = indexWriterFactory;
        this.writerStatus = writerStatus;
        this.dirFactory = dirFactory;
        this.dirFile = dirFile;
    }

    public void create() throws IOException {
        this.directory = this.dirFactory.open(this.dirFile);
        DirectorySupport.deleteDirectoryContents(this.directory);
        this.writer = this.indexWriterFactory.create(this.directory);
    }

    public void drop() throws IOException {
        this.writerStatus.close(this.writer);
        DirectorySupport.deleteDirectoryContents(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        try {
            if (populationCompletedSuccessfully) {
                this.flush();
                this.writerStatus.commitAsOnline(this.writer);
            }
        }
        finally {
            this.writerStatus.close(this.writer);
            this.directory.close();
        }
    }

    protected abstract void flush() throws IOException;
}

