/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.DirectorySupport;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.NodePropertyUpdate;

abstract class LuceneIndexAccessor
implements IndexAccessor {
    protected final LuceneDocumentStructure documentStructure;
    protected final SearcherManager searcherManager;
    protected final IndexWriter writer;
    private final IndexWriterStatus writerStatus;
    private final Directory dir;

    LuceneIndexAccessor(LuceneDocumentStructure documentStructure, LuceneIndexWriterFactory indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) throws IOException {
        this.documentStructure = documentStructure;
        this.dir = dirFactory.open(dirFile);
        this.writer = indexWriterFactory.create(this.dir);
        this.writerStatus = writerStatus;
        this.searcherManager = new SearcherManager(this.writer, true, new SearcherFactory());
    }

    public void updateAndCommit(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException {
        this.apply(false, updates);
    }

    public void recover(Iterable<NodePropertyUpdate> updates) throws IOException {
        this.apply(true, updates);
    }

    public void apply(boolean inRecovery, Iterable<NodePropertyUpdate> updates) throws IOException {
        block5: for (NodePropertyUpdate update : updates) {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    if (inRecovery) {
                        this.addRecovered(update.getNodeId(), update.getValueAfter());
                        continue block5;
                    }
                    this.add(update.getNodeId(), update.getValueAfter());
                    continue block5;
                }
                case CHANGED: {
                    this.change(update.getNodeId(), update.getValueAfter());
                    continue block5;
                }
                case REMOVED: {
                    this.remove(update.getNodeId());
                    continue block5;
                }
            }
            throw new UnsupportedOperationException();
        }
        this.searcherManager.maybeRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecovered(long nodeId, Object value) throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs hits = searcher.search((Query)new TermQuery(this.documentStructure.newQueryForChangeOrRemove(nodeId)), 1);
            if (hits.totalHits > 0) {
                this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocument(nodeId, value));
            } else {
                this.add(nodeId, value);
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    public void drop() throws IOException {
        this.closeIndexResources();
        DirectorySupport.deleteDirectoryContents(this.dir);
    }

    public void force() throws IOException {
        this.writerStatus.commitAsOnline(this.writer);
    }

    public void close() throws IOException {
        this.closeIndexResources();
        this.dir.close();
    }

    private void closeIndexResources() throws IOException {
        this.writerStatus.close(this.writer);
        this.searcherManager.close();
    }

    public IndexReader newReader() {
        return new LuceneIndexAccessorReader(this.searcherManager, this.documentStructure);
    }

    protected void add(long nodeId, Object value) throws IOException {
        this.writer.addDocument(this.documentStructure.newDocument(nodeId, value));
    }

    protected void change(long nodeId, Object valueAfter) throws IOException {
        this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocument(nodeId, valueAfter));
    }

    protected void remove(long nodeId) throws IOException {
        this.writer.deleteDocuments(this.documentStructure.newQueryForChangeOrRemove(nodeId));
    }
}

