/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.neo4j.helpers.collection.MapUtil;

class IndexWriterStatus {
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";

    IndexWriterStatus() {
    }

    public void commitAsOnline(IndexWriter writer) throws IOException {
        writer.commit(MapUtil.stringMap((String[])new String[]{KEY_STATUS, ONLINE}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return false;
        }
        IndexReader reader = null;
        try {
            reader = IndexReader.open((Directory)directory);
            Map userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void close(IndexWriter writer) throws IOException {
        writer.close(true);
    }
}

