/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.dialect.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.hibernate.ogm.grid.RowKey;
import org.infinispan.commons.marshall.AdvancedExternalizer;

public class RowKeyExternalizer
implements AdvancedExternalizer<RowKey> {
    public static final RowKeyExternalizer INSTANCE = new RowKeyExternalizer();
    private static final int VERSION = 1;
    private static final Set<Class<? extends RowKey>> TYPE_CLASSES = Collections.singleton(RowKey.class);

    private RowKeyExternalizer() {
    }

    public void writeObject(ObjectOutput output, RowKey key) throws IOException {
        output.writeInt(1);
        output.writeUTF(key.getTable());
        output.writeObject(key.getColumnNames());
        output.writeObject(key.getColumnValues());
    }

    public RowKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        input.readInt();
        String tableName = input.readUTF();
        String[] columnNames = (String[])input.readObject();
        Object[] values = (Object[])input.readObject();
        return new RowKey(tableName, columnNames, values);
    }

    public Set<Class<? extends RowKey>> getTypeClasses() {
        return TYPE_CLASSES;
    }

    public Integer getId() {
        return 1402;
    }
}

