/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.configurationreader.impl;

import java.util.List;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.ogm.util.configurationreader.impl.ClassPropertyReaderContextExpectingClassLoaderService;
import org.hibernate.ogm.util.configurationreader.impl.Instantiator;
import org.hibernate.ogm.util.configurationreader.impl.PropertyReaderContext;
import org.hibernate.ogm.util.configurationreader.impl.PropertyValidator;
import org.hibernate.ogm.util.configurationreader.impl.ShortNameResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class ClassPropertyReaderContext<T>
extends PropertyReaderContext<T>
implements ClassPropertyReaderContextExpectingClassLoaderService<T> {
    private static final Log log = LoggerFactory.make();
    private ClassLoaderService classLoaderService;
    private Class<? extends T> defaultImplementation;
    private String defaultImplementationName;
    private Instantiator<T> instantiator;
    private ShortNameResolver shortNameResolver;

    ClassPropertyReaderContext(Object value, String propertyName, Class<T> clazz, T defaultValue, boolean isRequired, List<PropertyValidator<T>> validators) {
        super(value, propertyName, clazz, defaultValue, isRequired, validators);
    }

    @Override
    public ClassPropertyReaderContext<T> withClassLoaderService(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
        return this;
    }

    public ClassPropertyReaderContext<T> withDefaultImplementation(Class<? extends T> defaultImplementation) {
        this.defaultImplementation = defaultImplementation;
        this.defaultImplementationName = null;
        return this;
    }

    public ClassPropertyReaderContext<T> withDefaultImplementation(String defaultImplementationName) {
        this.defaultImplementationName = defaultImplementationName;
        this.defaultImplementation = null;
        return this;
    }

    public ClassPropertyReaderContext<T> withInstantiator(Instantiator<T> instantiator) {
        this.instantiator = instantiator;
        return this;
    }

    public ClassPropertyReaderContext<T> withShortNameResolver(ShortNameResolver shortNameResolver) {
        this.shortNameResolver = shortNameResolver;
        return this;
    }

    @Override
    public T getTypedValue() {
        ShortNameResolver resolver = this.shortNameResolver != null ? this.shortNameResolver : NoOpNameResolver.INSTANCE;
        Instantiator instantiator = this.instantiator != null ? this.instantiator : DefaultInstantiator.getInstance();
        Object configuredValue = this.getConfiguredValue();
        Class targetType = this.getTargetType();
        Object typedValue = null;
        if (configuredValue == null) {
            typedValue = this.getDefaultValue(resolver, instantiator);
        } else if (targetType.isAssignableFrom(configuredValue.getClass())) {
            Object v;
            typedValue = v = configuredValue;
        } else if (configuredValue instanceof Class) {
            Class configuredClazz = this.narrowDownClass((Class)configuredValue, targetType);
            typedValue = instantiator.newInstance(configuredClazz);
        } else if (configuredValue instanceof String) {
            Class configuredClazz = this.getClassFromString((String)configuredValue, targetType, resolver);
            typedValue = instantiator.newInstance(configuredClazz);
        } else {
            throw log.unexpectedInstanceType(this.getPropertyName(), configuredValue.toString(), configuredValue.getClass().getName(), targetType.getName());
        }
        return (T)typedValue;
    }

    private T getDefaultValue(ShortNameResolver resolver, Instantiator<T> instantiator) {
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        if (this.defaultImplementationName != null) {
            this.defaultImplementation = this.getClassFromString(this.defaultImplementationName, this.getTargetType(), resolver);
        }
        return this.defaultImplementation != null ? (T)instantiator.newInstance(this.defaultImplementation) : null;
    }

    private Class<? extends T> getClassFromString(String className, Class<T> targetType, ShortNameResolver shortNameResolver) {
        if (shortNameResolver.isShortName(className)) {
            className = shortNameResolver.resolve(className);
        }
        Class clazz = null;
        try {
            clazz = this.classLoaderService.classForName(className);
        }
        catch (ClassLoadingException e) {
            throw log.unableToLoadClass(this.getPropertyName(), className, (Exception)((Object)e));
        }
        return this.narrowDownClass(clazz, targetType);
    }

    private Class<? extends T> narrowDownClass(Class<?> clazz, Class<T> targetType) {
        if (!targetType.isAssignableFrom(clazz)) {
            throw log.unexpectedClassType(this.getPropertyName(), clazz.getName(), targetType.getName());
        }
        Class<?> typed = clazz;
        return typed;
    }

    private static class DefaultInstantiator<T>
    implements Instantiator<T> {
        private static final DefaultInstantiator<?> INSTANCE = new DefaultInstantiator();

        private DefaultInstantiator() {
        }

        public static <T> DefaultInstantiator<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public T newInstance(Class<? extends T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw log.unableToInstantiateType(clazz.getName(), e);
            }
        }
    }

    private static class NoOpNameResolver
    implements ShortNameResolver {
        static final NoOpNameResolver INSTANCE = new NoOpNameResolver();

        private NoOpNameResolver() {
        }

        @Override
        public boolean isShortName(String name) {
            return false;
        }

        @Override
        public String resolve(String shortName) {
            throw new UnsupportedOperationException();
        }
    }
}

