/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.hibernate.type.descriptor.java.DateTypeDescriptor;

public class Iso8601DateTypeDescriptor
extends DateTypeDescriptor {
    public static final Iso8601DateTypeDescriptor DATE = new Iso8601DateTypeDescriptor(Type.DATE);
    public static final Iso8601DateTypeDescriptor TIME = new Iso8601DateTypeDescriptor(Type.TIME);
    public static final Iso8601DateTypeDescriptor DATE_TIME = new Iso8601DateTypeDescriptor(Type.DATE_TIME);
    private final Type type;

    private Iso8601DateTypeDescriptor(Type type) {
        this.type = type;
    }

    public Date fromString(String string) {
        return this.type.fromString(string);
    }

    public String toString(Date value) {
        return this.type.toString(value);
    }

    private static enum Type {
        DATE{

            @Override
            public Date fromString(String string) {
                return DatatypeConverter.parseDate((String)string).getTime();
            }

            @Override
            public String toString(Date value) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.setTime(value);
                return DatatypeConverter.printDate((Calendar)calendar);
            }
        }
        ,
        TIME{

            @Override
            public Date fromString(String string) {
                return DatatypeConverter.parseTime((String)string).getTime();
            }

            @Override
            public String toString(Date value) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.setTime(value);
                return DatatypeConverter.printTime((Calendar)calendar);
            }
        }
        ,
        DATE_TIME{

            @Override
            public Date fromString(String string) {
                return DatatypeConverter.parseDateTime((String)string).getTime();
            }

            @Override
            public String toString(Date value) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.setTime(value);
                return DatatypeConverter.printDateTime((Calendar)calendar);
            }
        };


        public abstract Date fromString(String var1);

        public abstract String toString(Date var1);
    }
}

