/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.spi.StartStoppable;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceInitiators;
import org.hibernate.service.Service;
import org.hibernate.service.internal.SessionFactoryServiceRegistryImpl;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

public class OgmSessionFactoryServiceRegistryImpl
extends SessionFactoryServiceRegistryImpl {
    private Configuration configuration = null;
    private SessionFactoryImplementor sessionFactory = null;

    public OgmSessionFactoryServiceRegistryImpl(ServiceRegistryImplementor parent, SessionFactoryImplementor sessionFactory, Configuration configuration) {
        super(parent, sessionFactory, configuration);
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
        this.createServiceBindings();
    }

    public OgmSessionFactoryServiceRegistryImpl(ServiceRegistryImplementor parent, SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        super(parent, sessionFactory, metadata);
        this.createServiceBindings();
    }

    private void createServiceBindings() {
        for (SessionFactoryServiceInitiator<?> inititator : OgmSessionFactoryServiceInitiators.LIST) {
            this.createServiceBinding((ServiceInitiator)inititator);
        }
    }

    public <R extends Service> void configureService(ServiceBinding<R> serviceBinding) {
        if (Configurable.class.isInstance(serviceBinding.getService())) {
            ((Configurable)serviceBinding.getService()).configure((Map)this.configuration.getProperties());
        }
    }

    public <R extends Service> void startService(ServiceBinding<R> serviceBinding) {
        super.startService(serviceBinding);
        if (StartStoppable.class.isInstance(serviceBinding.getService())) {
            ((StartStoppable)serviceBinding.getService()).start(this.configuration, this.sessionFactory);
        }
    }
}

