/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.UniqueOption;

public class OptionsContainer {
    public static final OptionsContainer EMPTY = new EmptyOptionsContainer();
    private static final ValueContainer<?, ?> EMPTY_VALUE_CONTAINER = new EmptyValueContainer();
    private final Map<Class<? extends Option<?, ?>>, ValueContainer<?, ?>> optionValues;

    public OptionsContainer(OptionsContainer source) {
        this.optionValues = new HashMap(source.optionValues.size());
        this.addAll(source);
    }

    public OptionsContainer() {
        this.optionValues = new HashMap();
    }

    public <I, V> void add(Option<I, V> option, V value) {
        this.getOrCreateValueContainer(option).add(option.getOptionIdentifier(), value);
    }

    public void addAll(OptionsContainer container) {
        for (Map.Entry<Class<Option<?, ?>>, ValueContainer<?, ?>> entry : container.optionValues.entrySet()) {
            this.addAll(entry.getKey(), entry.getValue());
        }
    }

    public <I, V> V get(Class<? extends Option<I, V>> optionType, I identifier) {
        return this.getNonNullValueContainer(optionType).get(identifier);
    }

    public <V> V getUnique(Class<? extends UniqueOption<V>> optionType) {
        return this.getNonNullValueContainer(optionType).getUnique();
    }

    public <I, V, T extends Option<I, V>> Map<I, V> getAll(Class<T> optionType) {
        return this.getNonNullValueContainer(optionType).getAll();
    }

    public String toString() {
        return "OptionsContainer [optionValues=" + this.optionValues + "]";
    }

    private <I, V> void addAll(Class<? extends Option<?, ?>> optionType, ValueContainer<?, ?> values) {
        ValueContainer<?, ?> valueContainer = this.getOrCreateValueContainer(optionType);
        valueContainer.addAll(values.getAll());
    }

    private <V, I> ValueContainer<I, V> getOrCreateValueContainer(Option<I, V> option) {
        Class<?> optionType = option.getClass();
        return this.getOrCreateValueContainer(optionType);
    }

    private <V, I> ValueContainer<I, V> getOrCreateValueContainer(Class<? extends Option<I, V>> optionType) {
        ValueContainer<I, V> values = this.getValueContainer(optionType);
        if (values == null) {
            values = this.createValueContainer(optionType);
            this.optionValues.put(optionType, values);
        }
        return values;
    }

    private <V, I> ValueContainer<I, V> getNonNullValueContainer(Class<? extends Option<I, V>> optionType) {
        ValueContainer<I, V> values = this.getValueContainer(optionType);
        return values != null ? values : this.getEmptyValueContainer();
    }

    private <V, I> ValueContainer<I, V> getValueContainer(Class<? extends Option<I, V>> optionType) {
        ValueContainer<?, ?> values = this.optionValues.get(optionType);
        return values;
    }

    private <I, V> ValueContainer<I, V> createValueContainer(Class<? extends Option<I, V>> optionType) {
        if (UniqueOption.class.isAssignableFrom(optionType)) {
            return new UniqueValueContainer();
        }
        return new NonUniqueValueContainer();
    }

    private <I, V> ValueContainer<I, V> getEmptyValueContainer() {
        return EMPTY_VALUE_CONTAINER;
    }

    private static class EmptyOptionsContainer
    extends OptionsContainer {
        private EmptyOptionsContainer() {
        }

        @Override
        public <I, V> void add(Option<I, V> option, V value) {
            throw new UnsupportedOperationException("No options may be added to this container ");
        }

        @Override
        public void addAll(OptionsContainer container) {
            throw new UnsupportedOperationException("No options may be added to this container ");
        }
    }

    private static class EmptyValueContainer<I, V>
    implements ValueContainer<I, V> {
        private EmptyValueContainer() {
        }

        @Override
        public void add(I identifier, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(Map<I, V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(I identifier) {
            return null;
        }

        @Override
        public V getUnique() {
            return null;
        }

        @Override
        public Map<I, V> getAll() {
            return Collections.emptyMap();
        }
    }

    private static class NonUniqueValueContainer<I, V>
    implements ValueContainer<I, V> {
        private final Map<I, V> values = new HashMap<I, V>();

        private NonUniqueValueContainer() {
        }

        @Override
        public void add(I identifier, V value) {
            this.values.put(identifier, value);
        }

        @Override
        public void addAll(Map<I, V> values) {
            this.values.putAll(values);
        }

        @Override
        public V get(I identifier) {
            return this.values.get(identifier);
        }

        @Override
        public V getUnique() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<I, V> getAll() {
            return this.values;
        }

        public String toString() {
            return "NonUniqueValueContainer [values=" + this.values + "]";
        }
    }

    private static class UniqueValueContainer<I, V>
    implements ValueContainer<I, V> {
        private I identifier;
        private V value;

        private UniqueValueContainer() {
        }

        @Override
        public void add(I identifier, V value) {
            this.identifier = identifier;
            this.value = value;
        }

        @Override
        public void addAll(Map<I, V> values) {
            for (Map.Entry<I, V> entry : values.entrySet()) {
                this.identifier = entry.getKey();
                this.value = entry.getValue();
            }
        }

        @Override
        public V get(I identifier) {
            return this.value;
        }

        @Override
        public V getUnique() {
            return this.value;
        }

        @Override
        public Map<I, V> getAll() {
            return Collections.singletonMap(this.identifier, this.value);
        }

        public String toString() {
            return "UniqueValueContainer [identifier=" + this.identifier + ", value=" + this.value + "]";
        }
    }

    private static interface ValueContainer<I, V> {
        public void add(I var1, V var2);

        public void addAll(Map<I, V> var1);

        public V get(I var1);

        public V getUnique();

        public Map<I, V> getAll();
    }
}

