/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.ogm.options.navigation.impl.AnnotationProcessor;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.OptionsContainer;
import org.hibernate.ogm.options.spi.OptionsService;

public class WritableOptionsServiceContext
implements OptionsService.OptionsServiceContext {
    private final OptionsContainer globaloptions = new OptionsContainer();
    private final ConcurrentMap<Class<?>, OptionsContainer> optionsPerEntity = new ConcurrentHashMap();
    private final ConcurrentMap<PropertyKey, OptionsContainer> optionsPerProperty = new ConcurrentHashMap<PropertyKey, OptionsContainer>();

    public <V> void addGlobalOption(Option<?, V> option, V value) {
        this.add(option, value, this.globaloptions);
    }

    public <V> void addEntityOption(Class<?> entityType, Option<?, V> option, V value) {
        OptionsContainer entityOptions = (OptionsContainer)this.optionsPerEntity.get(entityType);
        if (entityOptions == null) {
            entityOptions = this.getAndCacheAnnotationBasedEntityOptions(entityType);
        }
        this.add(option, value, entityOptions);
    }

    public <V> void addPropertyOption(Class<?> entityType, String propertyName, Option<?, V> option, V value) {
        PropertyKey key = new PropertyKey(entityType, propertyName);
        OptionsContainer propertyOptions = (OptionsContainer)this.optionsPerProperty.get(key);
        if (propertyOptions == null) {
            propertyOptions = this.getAndCacheAnnotationBasedPropertyOptions(key);
        }
        this.add(option, value, propertyOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void add(Option<?, V> option, V value, OptionsContainer container) {
        OptionsContainer optionsContainer = container;
        synchronized (optionsContainer) {
            container.add(option, value);
        }
    }

    @Override
    public OptionsContainer getGlobalOptions() {
        return this.copy(this.globaloptions);
    }

    @Override
    public OptionsContainer getEntityOptions(Class<?> entityType) {
        OptionsContainer entityOptions = (OptionsContainer)this.optionsPerEntity.get(entityType);
        if (entityOptions == null) {
            entityOptions = this.getAndCacheAnnotationBasedEntityOptions(entityType);
        }
        return this.copy(entityOptions);
    }

    @Override
    public OptionsContainer getPropertyOptions(Class<?> entityType, String propertyName) {
        PropertyKey key = new PropertyKey(entityType, propertyName);
        OptionsContainer propertyOptions = (OptionsContainer)this.optionsPerProperty.get(key);
        if (propertyOptions == null) {
            propertyOptions = this.getAndCacheAnnotationBasedPropertyOptions(key);
        }
        return this.copy(propertyOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionsContainer copy(OptionsContainer container) {
        OptionsContainer optionsContainer = container;
        synchronized (optionsContainer) {
            return new OptionsContainer(container);
        }
    }

    private OptionsContainer getAndCacheAnnotationBasedEntityOptions(Class<?> entityType) {
        OptionsContainer entityOptions = AnnotationProcessor.getEntityOptions(entityType);
        OptionsContainer cachedOptions = this.optionsPerEntity.putIfAbsent(entityType, entityOptions);
        if (cachedOptions != null) {
            entityOptions = cachedOptions;
        }
        return entityOptions;
    }

    private OptionsContainer getAndCacheAnnotationBasedPropertyOptions(PropertyKey key) {
        OptionsContainer cachedOptions;
        Map<PropertyKey, OptionsContainer> allPropertyOptions = AnnotationProcessor.getPropertyOptions(key.getEntity());
        for (Map.Entry<PropertyKey, OptionsContainer> option : allPropertyOptions.entrySet()) {
            this.optionsPerProperty.putIfAbsent(option.getKey(), option.getValue());
        }
        OptionsContainer propertyOptions = (OptionsContainer)this.optionsPerProperty.get(key);
        if (propertyOptions == null && (cachedOptions = this.optionsPerProperty.putIfAbsent(key, propertyOptions = new OptionsContainer())) != null) {
            propertyOptions = cachedOptions;
        }
        return propertyOptions;
    }

    public String toString() {
        return "WritableOptionsServiceContext [globaloptions=" + this.globaloptions + ", optionsPerEntity=" + this.optionsPerEntity + ", optionsPerProperty=" + this.optionsPerProperty + "]";
    }
}

