/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.cfg.impl.ConfigurableImpl;
import org.hibernate.ogm.cfg.spi.OptionConfigurator;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.options.navigation.impl.WritableOptionsServiceContext;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OptionsServiceImpl
implements OptionsService,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.make();
    private OptionsService.OptionsServiceContext sessionFactoryOptions;
    private ServiceRegistryImplementor registry;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.registry = serviceRegistry;
    }

    public void configure(Map configurationValues) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues);
        ClassLoaderService classLoaderService = (ClassLoaderService)this.registry.getService(ClassLoaderService.class);
        OptionsService.OptionsServiceContext context = (OptionsService.OptionsServiceContext)propertyReader.property("hibernate.ogm.options.context", OptionsService.OptionsServiceContext.class).instantiate().withClassLoaderService(classLoaderService).getValue();
        OptionConfigurator configurator = (OptionConfigurator)propertyReader.property("hibernate.ogm.option.configurator", OptionConfigurator.class).instantiate().withClassLoaderService(classLoaderService).getValue();
        if (context != null && configurator != null) {
            throw log.ambigiousOptionConfiguration("hibernate.ogm.option.configurator");
        }
        this.sessionFactoryOptions = configurator != null ? this.invoke(configurator) : (context != null ? context : new WritableOptionsServiceContext());
    }

    @Override
    public OptionsService.OptionsServiceContext context() {
        return this.sessionFactoryOptions;
    }

    @Override
    public OptionsService.OptionsServiceContext context(SessionImplementor session) {
        throw new UnsupportedOperationException("OGM-343 Session specific options are not currently supported");
    }

    private <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> OptionsService.OptionsServiceContext invoke(OptionConfigurator configurator) {
        ConfigurableImpl configurable = new ConfigurableImpl();
        configurator.configure(configurable);
        return configurable.getContext();
    }
}

