/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.options.spi.MappingOption;
import org.hibernate.ogm.options.spi.OptionValuePair;
import org.hibernate.ogm.options.spi.OptionsContainer;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.ReflectionHelper;

public class AnnotationProcessor {
    private static final Log log = LoggerFactory.make();

    public static OptionsContainer getEntityOptions(Class<?> entityType) {
        return AnnotationProcessor.convertOptionAnnotations(entityType.getAnnotations());
    }

    public static Map<PropertyKey, OptionsContainer> getPropertyOptions(Class<?> entityClass) {
        HashMap<PropertyKey, OptionsContainer> optionsByProperty = new HashMap<PropertyKey, OptionsContainer>();
        for (Method method : entityClass.getMethods()) {
            String propertyName = ReflectionHelper.getPropertyName(method);
            if (propertyName == null) continue;
            OptionsContainer optionsOfProperty = AnnotationProcessor.convertOptionAnnotations(method.getAnnotations());
            optionsByProperty.put(new PropertyKey(entityClass, propertyName), optionsOfProperty);
        }
        for (AccessibleObject accessibleObject : entityClass.getDeclaredFields()) {
            PropertyKey key = new PropertyKey(entityClass, ((Field)accessibleObject).getName());
            OptionsContainer optionsOfField = AnnotationProcessor.convertOptionAnnotations(accessibleObject.getAnnotations());
            OptionsContainer optionsOfProperty = (OptionsContainer)optionsByProperty.get(key);
            if (optionsOfProperty != null) {
                optionsOfProperty.addAll(optionsOfField);
                continue;
            }
            optionsByProperty.put(key, optionsOfField);
        }
        return optionsByProperty;
    }

    private static OptionsContainer convertOptionAnnotations(Annotation[] annotations) {
        OptionsContainer options = new OptionsContainer();
        for (Annotation annotation : annotations) {
            AnnotationProcessor.processAnnotation(options, annotation);
        }
        return options;
    }

    private static <A extends Annotation> void processAnnotation(OptionsContainer options, A annotation) {
        AnnotationConverter<A> converter = AnnotationProcessor.getConverter(annotation);
        if (converter != null) {
            AnnotationProcessor.add(options, converter.convert(annotation));
        }
    }

    private static <A extends Annotation> AnnotationConverter<A> getConverter(Annotation annotation) {
        MappingOption mappingOption = annotation.annotationType().getAnnotation(MappingOption.class);
        Class<AnnotationConverter<?>> converterClass = mappingOption != null ? mappingOption.value() : null;
        try {
            return converterClass != null ? converterClass.newInstance() : null;
        }
        catch (Exception e) {
            throw log.cannotConvertAnnotation(converterClass, e);
        }
    }

    private static <V> void add(OptionsContainer options, OptionValuePair<V> optionValue) {
        options.add(optionValue.getOption(), optionValue.getValue());
    }
}

