/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.loader.OgmLoader;
import org.hibernate.ogm.loader.OgmLoadingContext;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public class BackendCustomLoader
extends CustomLoader {
    private final CustomQuery customQuery;

    public BackendCustomLoader(CustomQuery customQuery, SessionFactoryImplementor factory) {
        super(customQuery, factory);
        this.customQuery = customQuery;
    }

    protected List list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws HibernateException {
        Iterator<Tuple> tuples = this.executeQuery(session, this.service(session, GridDialect.class), resultTypes);
        ArrayList results = new ArrayList();
        while (tuples.hasNext()) {
            Tuple tuple = tuples.next();
            for (Type type : resultTypes) {
                OgmLoader loader = this.createLoader(session, type.getReturnedClass());
                results.add(this.entity(session, tuple, loader));
            }
        }
        return results;
    }

    private Iterator<Tuple> executeQuery(SessionImplementor session, GridDialect dialect, Type[] resultTypes) {
        Loadable[] entityPersisters = this.getEntityPersisters();
        EntityKeyMetadata[] metadatas = new EntityKeyMetadata[entityPersisters.length];
        for (int i = 0; i < metadatas.length; ++i) {
            metadatas[i] = this.metadata(session.getFactory(), resultTypes[i]);
        }
        return dialect.executeBackendQuery(this.customQuery, metadatas);
    }

    private <T extends Service> T service(SessionImplementor session, Class<T> serviceRole) {
        return (T)this.serviceRegistry(session).getService(serviceRole);
    }

    private ServiceRegistryImplementor serviceRegistry(SessionImplementor session) {
        return session.getFactory().getServiceRegistry();
    }

    private <T> T entity(SessionImplementor session, Tuple tuple, OgmLoader loader) {
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(Arrays.asList(tuple));
        List<Object> entities = loader.loadEntities(session, LockOptions.NONE, ogmLoadingContext);
        return (T)entities.get(0);
    }

    private OgmLoader createLoader(SessionImplementor session, Class<?> entityClass) {
        OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getEntityPersister(entityClass.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
        return loader;
    }

    private EntityKeyMetadata metadata(SessionFactoryImplementor sessionFactory, Type resultType) {
        OgmEntityPersister persister = (OgmEntityPersister)sessionFactory.getEntityPersister(resultType.getName());
        return new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
    }
}

