/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.util.Arrays;
import org.hibernate.ogm.grid.Key;

public final class RowKey
implements Key {
    private final String table;
    private final String[] columnNames;
    private final Object[] columnValues;
    private final int hashCode;

    public RowKey(String table, String[] columnNames, Object[] columnValues) {
        this.table = table;
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || RowKey.class != o.getClass()) {
            return false;
        }
        RowKey that = (RowKey)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, that.columnValues)) {
            return false;
        }
        return Arrays.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.table.hashCode();
        return 31 * result + Arrays.hashCode(this.columnValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RowKey");
        sb.append("{table='").append(this.table).append('\'');
        sb.append(", columnNames=").append(this.columnNames == null ? "null" : Arrays.asList(this.columnNames).toString());
        sb.append(", columnValues=").append(this.columnValues == null ? "null" : Arrays.asList(this.columnValues).toString());
        sb.append('}');
        return sb.toString();
    }
}

