/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapDatastoreProvider;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.map.impl.MapPessimisticReadLockingStrategy;
import org.hibernate.ogm.datastore.map.impl.MapPessimisticWriteLockingStrategy;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.ogm.type.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;

public class MapDialect
implements GridDialect {
    private final MapDatastoreProvider provider;

    public MapDialect(MapDatastoreProvider provider) {
        this.provider = provider;
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE) {
            return new MapPessimisticWriteLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return new MapPessimisticReadLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        return new MapPessimisticWriteLockingStrategy(lockable, lockMode);
    }

    @Override
    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Map<String, Object> entityMap = this.provider.getEntityTuple(key);
        if (entityMap == null) {
            return null;
        }
        return new Tuple(new MapTupleSnapshot(entityMap));
    }

    @Override
    public Tuple createTuple(EntityKey key) {
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        this.provider.putEntity(key, tuple);
        return new Tuple(new MapTupleSnapshot(tuple));
    }

    @Override
    public void updateTuple(Tuple tuple, EntityKey key) {
        Map<String, Object> entityRecord = ((MapTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap(tuple, entityRecord);
    }

    @Override
    public void removeTuple(EntityKey key) {
        this.provider.removeEntityTuple(key);
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Map<RowKey, Map<String, Object>> associationMap = this.provider.getAssociation(key);
        return associationMap == null ? null : new Association(new MapAssociationSnapshot(associationMap));
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        HashMap<RowKey, Map<String, Object>> associationMap = new HashMap<RowKey, Map<String, Object>>();
        this.provider.putAssociation(key, associationMap);
        return new Association(new MapAssociationSnapshot(associationMap));
    }

    @Override
    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        MapHelpers.updateAssociation(association, key);
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        this.provider.removeAssociation(key);
    }

    @Override
    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple();
    }

    @Override
    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return false;
    }

    @Override
    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        int nextValue = this.provider.getSharedAtomicInteger(key, initialValue, increment);
        value.initialize((long)nextValue);
    }

    @Override
    public GridType overrideType(Type type) {
        return null;
    }

    @Override
    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... metadatas) {
        Map<EntityKey, Map<String, Object>> entityMap = this.provider.getEntityMap();
        for (EntityKey key : entityMap.keySet()) {
            for (EntityKeyMetadata metadata : metadatas) {
                if (!key.getTable().equals(metadata.getTable())) continue;
                consumer.consume(new Tuple(new MapTupleSnapshot(entityMap.get(key))));
            }
        }
    }

    @Override
    public Iterator<Tuple> executeBackendQuery(CustomQuery customQuery, EntityKeyMetadata[] metadatas) {
        throw new UnsupportedOperationException("Native queries not supported for Map");
    }
}

