/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.spi.OptionsContext;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.options.spi.UniqueOption;

public class PropertyOptionsContext
implements OptionsContext {
    private final OptionsService.OptionsServiceContext optionsServiceContext;
    private final Class<?> entityType;
    private final String propertyName;
    private final List<Class<?>> hierarchy;

    public PropertyOptionsContext(OptionsService.OptionsServiceContext optionsServiceContext, Class<?> entityType, String propertyName) {
        this.optionsServiceContext = optionsServiceContext;
        this.entityType = entityType;
        this.propertyName = propertyName;
        this.hierarchy = PropertyOptionsContext.getClassHierarchy(entityType);
    }

    @Override
    public <I, V> V get(Class<? extends Option<I, V>> optionType, I identifier) {
        Object optionValue;
        for (Class<?> clazz : this.hierarchy) {
            optionValue = this.optionsServiceContext.getPropertyOptions(clazz, this.propertyName).get(optionType, identifier);
            if (optionValue == null) continue;
            return optionValue;
        }
        for (Class<?> clazz : this.hierarchy) {
            optionValue = this.optionsServiceContext.getEntityOptions(clazz).get(optionType, identifier);
            if (optionValue == null) continue;
            return optionValue;
        }
        return this.optionsServiceContext.getGlobalOptions().get(optionType, identifier);
    }

    @Override
    public <V> V getUnique(Class<? extends UniqueOption<V>> optionType) {
        Object optionValue;
        for (Class<?> clazz : this.hierarchy) {
            optionValue = this.optionsServiceContext.getPropertyOptions(clazz, this.propertyName).getUnique(optionType);
            if (optionValue == null) continue;
            return optionValue;
        }
        for (Class<?> clazz : this.hierarchy) {
            optionValue = this.optionsServiceContext.getEntityOptions(clazz).getUnique(optionType);
            if (optionValue == null) continue;
            return optionValue;
        }
        return this.optionsServiceContext.getGlobalOptions().getUnique(optionType);
    }

    @Override
    public <I, V, T extends Option<I, V>> Map<I, V> getAll(Class<T> optionType) {
        Map optionValues;
        for (Class<?> clazz : this.hierarchy) {
            optionValues = this.optionsServiceContext.getPropertyOptions(clazz, this.propertyName).getAll(optionType);
            if (optionValues == null) continue;
            return optionValues;
        }
        for (Class<?> clazz : this.hierarchy) {
            optionValues = this.optionsServiceContext.getEntityOptions(clazz).getAll(optionType);
            if (optionValues == null) continue;
            return optionValues;
        }
        return this.optionsServiceContext.getGlobalOptions().getAll(optionType);
    }

    private static List<Class<?>> getClassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = new ArrayList(4);
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            hierarchy.add(current);
        }
        return hierarchy;
    }

    public String toString() {
        return "PropertyOptionsContext [optionsServiceContext=" + this.optionsServiceContext + ", entityType=" + this.entityType + ", propertyName=" + this.propertyName + "]";
    }
}

