/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.impl.AvailableDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.impl.ShortNameResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

public final class DatastoreProviderInitiator
implements SessionFactoryServiceInitiator<DatastoreProvider> {
    public static final DatastoreProviderInitiator INSTANCE = new DatastoreProviderInitiator();
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_DATASTORE_PROVIDER = "infinispan";

    public Class<DatastoreProvider> getServiceInitiated() {
        return DatastoreProvider.class;
    }

    public DatastoreProvider initiateService(SessionFactoryImplementor sessionFactory, Configuration configuration, ServiceRegistryImplementor registry) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configuration);
        DatastoreProvider datastoreProvider = (DatastoreProvider)propertyReader.property("hibernate.ogm.datastore.provider", DatastoreProvider.class).instantiate().withClassLoaderService((ClassLoaderService)registry.getService(ClassLoaderService.class)).withDefaultImplementation(DEFAULT_DATASTORE_PROVIDER).withShortNameResolver(DatastoreProviderShortNameResolver.INSTANCE).getValue();
        log.useDatastoreProvider(datastoreProvider.getClass().getName());
        return datastoreProvider;
    }

    public DatastoreProvider initiateService(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, ServiceRegistryImplementor registry) {
        throw new UnsupportedOperationException("Cannot create " + DatastoreProvider.class.getName() + " service using metadata");
    }

    public static class DatastoreProviderShortNameResolver
    implements ShortNameResolver {
        private static final DatastoreProviderShortNameResolver INSTANCE = new DatastoreProviderShortNameResolver();

        @Override
        public boolean isShortName(String name) {
            return AvailableDatastoreProvider.isShortName(name);
        }

        @Override
        public String resolve(String shortName) {
            return AvailableDatastoreProvider.byShortName(shortName).getDatastoreProviderClassName();
        }
    }
}

