/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.spi.AbstractEntityManagerImpl;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.jpa.impl.LetThroughExecuteUpdateQuery;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.jpa.impl.OgmJpaQuery;

public class OgmEntityManager
implements EntityManager {
    private final EntityManager hibernateEm;
    private final OgmEntityManagerFactory factory;
    private final LockOptions lockOptions = new LockOptions();

    public OgmEntityManager(OgmEntityManagerFactory factory, EntityManager hibernateEm) {
        this.hibernateEm = hibernateEm;
        this.factory = factory;
    }

    public void persist(Object entity) {
        this.hibernateEm.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.hibernateEm.merge(entity);
    }

    public void remove(Object entity) {
        this.hibernateEm.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.hibernateEm.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.hibernateEm.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.hibernateEm.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.hibernateEm.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.hibernateEm.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.hibernateEm.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.hibernateEm.clear();
    }

    public void detach(Object entity) {
        this.hibernateEm.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.hibernateEm.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.hibernateEm.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.hibernateEm.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.hibernateEm.getProperties();
    }

    public javax.persistence.Query createQuery(String qlString) {
        if (qlString != null && qlString.toLowerCase().startsWith("delete from")) {
            return new LetThroughExecuteUpdateQuery();
        }
        Session session = (Session)this.getDelegate();
        return this.applyProperties((javax.persistence.Query)new OgmJpaQuery(session.createQuery(qlString), (EntityManager)((AbstractEntityManagerImpl)this.hibernateEm)));
    }

    private javax.persistence.Query applyProperties(javax.persistence.Query query) {
        Object lockTimeout;
        Object queryTimeout;
        if (this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode(this.lockOptions.getLockMode()));
        }
        if ((queryTimeout = this.getProperties().get("javax.persistence.query.timeout")) != null) {
            query.setHint("javax.persistence.query.timeout", queryTimeout);
        }
        if ((lockTimeout = this.getProperties().get("javax.persistence.lock.timeout")) != null) {
            query.setHint("javax.persistence.lock.timeout", lockTimeout);
        }
        return query;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public javax.persistence.Query createQuery(CriteriaUpdate updateQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public javax.persistence.Query createQuery(CriteriaDelete deleteQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        Session session = (Session)this.getDelegate();
        Query query = session.createQuery(qlString);
        this.resultClassChecking(resultClass, query);
        return new OgmJpaQuery(query, (EntityManager)((AbstractEntityManagerImpl)this.hibernateEm));
    }

    public javax.persistence.Query createNamedQuery(String name) {
        return this.buildQueryFromName(name, null);
    }

    private <T> TypedQuery<T> buildQueryFromName(String name, Class<T> resultType) {
        OgmSessionFactory sessionFactory = (OgmSessionFactory)this.factory.getSessionFactory();
        NamedSQLQueryDefinition queryDefinition = sessionFactory.getNamedSQLQuery(name);
        if (queryDefinition == null) {
            queryDefinition = sessionFactory.getNamedQuery(name);
            if (queryDefinition == null) {
                throw new IllegalArgumentException("Named query not found: " + name);
            }
            return this.createNamedJpqlQuery((NamedQueryDefinition)queryDefinition, resultType);
        }
        return this.createNamedNativeQuery(queryDefinition, resultType);
    }

    protected <T> TypedQuery<T> createNamedJpqlQuery(NamedQueryDefinition namedQueryDefinition, Class<T> resultType) {
        SessionImplementor session = (SessionImplementor)this.getDelegate();
        Query query = session.createQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, query);
        }
        return this.wrapAsJpaQuery(namedQueryDefinition, query);
    }

    protected <T> TypedQuery<T> wrapAsJpaQuery(NamedQueryDefinition namedQueryDefinition, Query hibQuery) {
        OgmJpaQuery jpaQuery = new OgmJpaQuery(hibQuery, (EntityManager)((AbstractEntityManagerImpl)this.hibernateEm));
        this.applySavedSettings(namedQueryDefinition, jpaQuery);
        return jpaQuery;
    }

    protected <T> void applySavedSettings(NamedQueryDefinition namedQueryDefinition, OgmJpaQuery<T> jpaQuery) {
        AbstractEntityManagerImpl impl = (AbstractEntityManagerImpl)this.hibernateEm;
        impl.applySavedSettings(namedQueryDefinition, jpaQuery);
    }

    private <T> TypedQuery<T> createNamedNativeQuery(NamedSQLQueryDefinition sqlDefinition, Class<T> resultType) {
        if (resultType != null) {
            this.resultClassChecking(resultType, sqlDefinition);
        }
        String sqlQueryString = sqlDefinition.getQueryString();
        SQLQuery noSqlQuery = ((Session)this.getDelegate()).createSQLQuery(sqlQueryString);
        if (sqlDefinition.getQueryReturns().length == 1) {
            NativeSQLQueryRootReturn rootReturn = (NativeSQLQueryRootReturn)sqlDefinition.getQueryReturns()[0];
            noSqlQuery.addEntity("alias1", rootReturn.getReturnEntityName(), LockMode.READ);
        }
        return new OgmJpaQuery((Query)noSqlQuery, this.hibernateEm);
    }

    protected void resultClassChecking(Class<?> resultClass, Query hqlQuery) {
        AbstractEntityManagerImpl impl = (AbstractEntityManagerImpl)this.hibernateEm;
        impl.resultClassChecking(resultClass, hqlQuery);
    }

    protected void resultClassChecking(Class<?> resultType, NamedSQLQueryDefinition namedQueryDefinition) {
        AbstractEntityManagerImpl impl = (AbstractEntityManagerImpl)this.hibernateEm;
        impl.resultClassChecking(resultType, namedQueryDefinition);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.buildQueryFromName(name, resultClass);
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        q.addEntity("alias1", resultClass.getName(), LockMode.READ);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        SQLQuery q = ((Session)this.getDelegate()).createSQLQuery(sqlString);
        q.setResultSetMapping(resultSetMapping);
        return new OgmJpaQuery((Query)q, this.hibernateEm);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        throw new IllegalStateException("Hibernate OGM does not support entity graphs");
    }

    public void joinTransaction() {
        this.hibernateEm.joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.hibernateEm.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        Object session = this.hibernateEm.unwrap(cls);
        if (Session.class.isAssignableFrom(cls) || SessionImplementor.class.isAssignableFrom(cls)) {
            return (T)((Object)this.buildOgmSession((Session)((EventSource)session)));
        }
        throw new HibernateException("Cannot unwrap the following type: " + cls);
    }

    private OgmSession buildOgmSession(Session session) {
        SessionFactory sessionFactory = ((HibernateEntityManagerFactory)this.hibernateEm.getEntityManagerFactory()).getSessionFactory();
        OgmSessionFactoryImpl ogmSessionFactory = new OgmSessionFactoryImpl((SessionFactoryImplementor)sessionFactory);
        return new OgmSession(ogmSessionFactory, (EventSource)session);
    }

    public Object getDelegate() {
        Object delegate = this.hibernateEm.getDelegate();
        if (Session.class.isAssignableFrom(delegate.getClass())) {
            return this.buildOgmSession((Session)((EventSource)delegate));
        }
        return delegate;
    }

    public void close() {
        this.hibernateEm.close();
    }

    public boolean isOpen() {
        return this.hibernateEm.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.hibernateEm.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.hibernateEm.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.hibernateEm.getMetamodel();
    }
}

