/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentrality;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class EigenvectorCentralityPower
implements EigenvectorCentrality {
    protected Direction relationDirection;
    protected CostEvaluator<Double> costEvaluator;
    protected Set<Node> nodeSet;
    protected Set<Relationship> relationshipSet;
    protected double precision = 0.001;
    protected boolean doneCalculation = false;
    protected Map<Node, Double> values;
    protected int totalIterations = 0;
    private int maxIterations = Integer.MAX_VALUE;

    public EigenvectorCentralityPower(Direction relationDirection, CostEvaluator<Double> costEvaluator, Set<Node> nodeSet, Set<Relationship> relationshipSet, double precision) {
        this.relationDirection = relationDirection;
        this.costEvaluator = costEvaluator;
        this.nodeSet = nodeSet;
        this.relationshipSet = relationshipSet;
        this.precision = precision;
    }

    @Override
    public Double getCentrality(Node node) {
        this.calculate();
        return this.values.get(node);
    }

    @Override
    public void reset() {
        this.doneCalculation = false;
    }

    @Override
    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        this.values = new HashMap<Node, Double>();
        this.totalIterations = 0;
        Random random = new Random(System.currentTimeMillis());
        for (Node node : this.nodeSet) {
            this.values.put(node, random.nextDouble());
        }
        this.normalize(this.values);
        this.runIterations(this.maxIterations);
    }

    public int runIterations(int maxNrIterations) {
        if (maxNrIterations <= 0) {
            return 0;
        }
        int localIterations = 0;
        do {
            ++localIterations;
            ++this.totalIterations;
            HashMap<Node, Double> newValues = new HashMap<Node, Double>();
            for (Relationship relationship : this.relationshipSet) {
                if (this.relationDirection.equals((Object)Direction.BOTH) || this.relationDirection.equals((Object)Direction.OUTGOING)) {
                    this.processRelationship(newValues, relationship, false);
                }
                if (!this.relationDirection.equals((Object)Direction.BOTH) && !this.relationDirection.equals((Object)Direction.INCOMING)) continue;
                this.processRelationship(newValues, relationship, true);
            }
            this.normalize(newValues);
            if (this.timeToStop(this.values, newValues)) {
                this.values = newValues;
                break;
            }
            this.values = newValues;
        } while (localIterations < maxNrIterations);
        if (this.values.get(this.nodeSet.iterator().next()) < 0.0) {
            for (Node node : this.nodeSet) {
                this.values.put(node, -this.values.get(node).doubleValue());
            }
        }
        return localIterations;
    }

    private boolean timeToStop(Map<Node, Double> oldValues, Map<Node, Double> newValues) {
        for (Node node : oldValues.keySet()) {
            if (newValues.get(node) == null) {
                return false;
            }
            if (oldValues.get(node) == 0.0) {
                if (!(Math.abs(newValues.get(node)) > this.precision)) continue;
                return false;
            }
            double factor = newValues.get(node) / oldValues.get(node);
            if (!((factor = Math.abs(factor)) - this.precision > 1.0) && !(factor + this.precision < 1.0)) continue;
            return false;
        }
        return true;
    }

    protected void processRelationship(Map<Node, Double> newValues, Relationship relationship, boolean backwards) {
        Node endNode;
        Double newValue;
        Node startNode = relationship.getStartNode();
        if (backwards) {
            startNode = relationship.getEndNode();
        }
        if ((newValue = newValues.get(endNode = relationship.getOtherNode(startNode))) == null) {
            newValue = 0.0;
        }
        if (this.values.get(startNode) != null) {
            newValue = newValue + this.values.get(startNode) * this.costEvaluator.getCost(relationship, backwards ? Direction.INCOMING : Direction.OUTGOING);
        }
        newValues.put(endNode, newValue);
    }

    protected void normalize(Map<Node, Double> vector) {
        double sum = 0.0;
        for (Node node : vector.keySet()) {
            double d = vector.get(node);
            sum += d * d;
        }
        if ((sum = Math.sqrt(sum)) > 0.0) {
            for (Node node : vector.keySet()) {
                vector.put(node, vector.get(node) / sum);
            }
        }
    }

    public int getTotalIterations() {
        return this.totalIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

