/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.DataSourceRegistrationListener;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class KernelBean
extends Neo4jMBean
implements Kernel {
    private final long kernelStartTime;
    private final String kernelVersion;
    private final ObjectName query;
    private final String instanceId;
    private final DataSourceInfo dataSourceInfo = new DataSourceInfo();
    private boolean isReadOnly;
    private long storeCreationDate = -1L;
    private long storeId = -1L;
    private String storeDir = null;
    private long storeLogVersion;

    KernelBean(KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(Kernel.class, kernel, support);
        ((XaDataSourceManager)kernel.graphDatabase().getDependencyResolver().resolveDependency(XaDataSourceManager.class)).addDataSourceRegistrationListener((DataSourceRegistrationListener)this.dataSourceInfo);
        this.kernelVersion = kernel.version().toString();
        this.instanceId = kernel.instanceId();
        this.query = support.createMBeanQuery(this.instanceId);
        this.kernelStartTime = new Date().getTime();
    }

    String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ObjectName getMBeanQuery() {
        return this.query;
    }

    @Override
    public Date getKernelStartTime() {
        return new Date(this.kernelStartTime);
    }

    @Override
    public Date getStoreCreationDate() {
        return new Date(this.storeCreationDate);
    }

    @Override
    public String getStoreId() {
        return Long.toHexString(this.storeId);
    }

    @Override
    public long getStoreLogVersion() {
        return this.storeLogVersion;
    }

    @Override
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public String getStoreDirectory() {
        return this.storeDir;
    }

    private class DataSourceInfo
    implements DataSourceRegistrationListener {
        private DataSourceInfo() {
        }

        public void registeredDataSource(XaDataSource ds) {
            if (ds instanceof NeoStoreXaDataSource) {
                NeoStoreXaDataSource datasource = (NeoStoreXaDataSource)ds;
                KernelBean.this.storeCreationDate = datasource.getCreationTime();
                KernelBean.this.storeLogVersion = datasource.getCurrentLogVersion();
                KernelBean.this.isReadOnly = datasource.isReadOnly();
                KernelBean.this.storeId = datasource.getRandomIdentifier();
                try {
                    KernelBean.this.storeDir = new File(datasource.getStoreDir()).getCanonicalFile().getAbsolutePath();
                }
                catch (IOException e) {
                    KernelBean.this.storeDir = new File(datasource.getStoreDir()).getAbsolutePath();
                }
            }
        }

        public void unregisteredDataSource(XaDataSource ds) {
            if (ds instanceof NeoStoreXaDataSource) {
                KernelBean.this.storeCreationDate = -1L;
                KernelBean.this.storeLogVersion = -1L;
                KernelBean.this.isReadOnly = false;
                KernelBean.this.storeId = -1L;
                KernelBean.this.storeDir = null;
            }
        }
    }
}

