/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.predicate.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.regex.Pattern;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.ogm.datastore.mongodb.util.impl.LikeExpressionToRegExpConverter;

public class MongoDBLikePredicate
extends LikePredicate<DBObject>
implements NegatablePredicate<DBObject> {
    private final Pattern pattern;

    public MongoDBLikePredicate(String propertyName, String patternValue, Character escapeCharacter) {
        super(propertyName, patternValue, escapeCharacter);
        LikeExpressionToRegExpConverter converter = new LikeExpressionToRegExpConverter(escapeCharacter);
        this.pattern = converter.getRegExpFromLikeExpression(patternValue);
    }

    public DBObject getQuery() {
        return new BasicDBObject(this.propertyName, (Object)this.pattern);
    }

    public DBObject getNegatedQuery() {
        return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$not", (Object)this.pattern));
    }
}

