/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl.configuration;

import com.mongodb.MongoClientOptions;
import com.mongodb.WriteConcern;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.cfg.impl.DocumentStoreConfiguration;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.AssociationDocumentType;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.ogm.util.configurationreader.impl.PropertyValidator;

public class MongoDBConfiguration
extends DocumentStoreConfiguration {
    public static final WriteConcern DEFAULT_WRITE_CONCERN = WriteConcern.ACKNOWLEDGED;
    public static final String DEFAULT_ASSOCIATION_STORE = "Associations";
    public static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_PORT = 27017;
    private static final Log log = LoggerFactory.getLogger();
    private static final TimeoutValidator TIMEOUT_VALIDATOR = new TimeoutValidator();
    private final AssociationDocumentType associationDocumentStorage;
    private final int timeout;
    private final WriteConcern writeConcern;

    public MongoDBConfiguration(Map<?, ?> configurationValues) {
        super(configurationValues, 27017);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues);
        this.timeout = (Integer)propertyReader.property("hibernate.ogm.mongodb.connection_timeout", Integer.TYPE).withDefault((Object)5000).withValidator((PropertyValidator)TIMEOUT_VALIDATOR).getValue();
        this.associationDocumentStorage = (AssociationDocumentType)((Object)propertyReader.property("hibernate.ogm.mongodb.association_document_storage", AssociationDocumentType.class).withDefault((Object)AssociationDocumentType.GLOBAL_COLLECTION).getValue());
        this.writeConcern = this.buildWriteConcern(configurationValues);
    }

    public AssociationDocumentType getAssociationDocumentStorage() {
        return this.associationDocumentStorage;
    }

    private WriteConcern buildWriteConcern(Map<?, ?> cfg) {
        Object cfgWriteConcern = cfg.get("hibernate.ogm.mongodb.write_concern");
        WriteConcern writeConcern = DEFAULT_WRITE_CONCERN;
        String wcLogMessage = "ACKNOWLEDGED";
        if (cfgWriteConcern != null) {
            String confWC = cfgWriteConcern.toString();
            writeConcern = WriteConcern.valueOf((String)confWC);
            if (writeConcern == null) {
                writeConcern = DEFAULT_WRITE_CONCERN;
                wcLogMessage = "ACKNOWLEDGED";
            } else {
                wcLogMessage = confWC;
            }
        }
        log.useWriteConcern(wcLogMessage);
        return writeConcern;
    }

    public MongoClientOptions buildOptions() {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.connectTimeout(this.timeout);
        optionsBuilder.writeConcern(this.writeConcern);
        return optionsBuilder.build();
    }

    private static class TimeoutValidator
    implements PropertyValidator<Integer> {
        private TimeoutValidator() {
        }

        public void validate(Integer value) throws HibernateException {
            if (value < 0) {
                throw log.mongoDBTimeOutIllegalValue(value);
            }
        }
    }
}

