/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.impl.cleanup.CleanupService;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Token;

public class GlobalGraphOperations {
    private final NodeManager nodeManager;
    private final CleanupService cleanupService;
    private final ThreadToStatementContextBridge statementCtxProvider;

    private GlobalGraphOperations(GraphDatabaseService db) {
        GraphDatabaseAPI dbApi = (GraphDatabaseAPI)db;
        DependencyResolver resolver = dbApi.getDependencyResolver();
        this.nodeManager = resolver.resolveDependency(NodeManager.class);
        this.cleanupService = resolver.resolveDependency(CleanupService.class);
        this.statementCtxProvider = resolver.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public static GlobalGraphOperations at(GraphDatabaseService db) {
        return new GlobalGraphOperations(db);
    }

    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllNodes();
            }
        };
    }

    public Iterable<Relationship> getAllRelationships() {
        return new Iterable<Relationship>(){

            @Override
            public Iterator<Relationship> iterator() {
                return GlobalGraphOperations.this.nodeManager.getAllRelationships();
            }
        };
    }

    public Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }

    public ResourceIterable<Label> getAllLabels() {
        return new ResourceIterable<Label>(){

            @Override
            public ResourceIterator<Label> iterator() {
                StatementContext ctx = GlobalGraphOperations.this.statementCtxProvider.getCtxForReading();
                return GlobalGraphOperations.this.cleanupService.resourceIterator(Iterables.map(new Function<Token, Label>(){

                    @Override
                    public Label apply(Token labelToken) {
                        return DynamicLabel.label(labelToken.name());
                    }
                }, ctx.labelsGetAllTokens()), ctx);
            }
        };
    }

    public ResourceIterable<Node> getAllNodesWithLabel(final Label label) {
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return GlobalGraphOperations.this.allNodesWithLabel(label.name());
            }
        };
    }

    private ResourceIterator<Node> allNodesWithLabel(String label) {
        StatementContext context = this.statementCtxProvider.getCtxForReading();
        try {
            long labelId = context.labelGetForName(label);
            Iterator<Long> nodeIds = context.nodesGetForLabel(labelId);
            return this.cleanupService.resourceIterator(Iterables.map(new Function<Long, Node>(){

                @Override
                public Node apply(Long nodeId) {
                    return GlobalGraphOperations.this.nodeManager.getNodeById(nodeId);
                }
            }, nodeIds), context);
        }
        catch (LabelNotFoundKernelException e) {
            context.close();
            return IteratorUtil.emptyIterator();
        }
    }
}

