/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.neo4j.kernel.info.LockingTransaction;
import org.neo4j.kernel.info.ResourceType;
import org.neo4j.kernel.info.WaitingThread;

public final class LockInfo {
    private final String resource;
    private final ResourceType type;
    private final int readCount;
    private final int writeCount;
    private final List<WaitingThread> waitingThreads;
    private final List<LockingTransaction> lockingTransactions;

    @ConstructorProperties(value={"resourceType", "resourceId", "readCount", "writeCount", "lockingTransactions", "waitingThreads"})
    public LockInfo(ResourceType type, String resourceId, int readCount, int writeCount, List<LockingTransaction> lockingTransactions, List<WaitingThread> waitingThreads) {
        this.type = type;
        this.resource = resourceId;
        this.readCount = readCount;
        this.writeCount = writeCount;
        this.lockingTransactions = new ArrayList<LockingTransaction>(lockingTransactions);
        this.waitingThreads = new ArrayList<WaitingThread>(waitingThreads);
    }

    public LockInfo(ResourceType type, String resourceId, int readCount, int writeCount, Collection<LockingTransaction> locking) {
        this.type = type;
        this.resource = resourceId;
        this.readCount = readCount;
        this.writeCount = writeCount;
        this.waitingThreads = new ArrayList<WaitingThread>();
        this.lockingTransactions = new ArrayList<LockingTransaction>(locking);
        for (LockingTransaction tx : this.lockingTransactions) {
            if (!(tx instanceof WaitingThread)) continue;
            this.waitingThreads.add((WaitingThread)tx);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Total lock count: readCount=" + this.getReadCount() + " writeCount=" + this.getWriteCount() + " for " + this.getResourceType().toString(this.getResourceId())).append("\n");
        builder.append("Lock holders:\n");
        for (LockingTransaction tle : this.getLockingTransactions()) {
            builder.append(tle).append("\n");
        }
        builder.append("Waiting list:").append("\n");
        StringBuilder waitList = new StringBuilder();
        String sep = "";
        for (WaitingThread we : this.getWaitingThreads()) {
            waitList.append(sep).append(we);
            sep = ", ";
        }
        builder.append((CharSequence)waitList).append("\n");
        return builder.toString();
    }

    public ResourceType getResourceType() {
        return this.type;
    }

    public String getResourceId() {
        return this.resource;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public int getWaitingThreadsCount() {
        return this.waitingThreads.size();
    }

    public List<WaitingThread> getWaitingThreads() {
        return Collections.unmodifiableList(this.waitingThreads);
    }

    public List<LockingTransaction> getLockingTransactions() {
        return Collections.unmodifiableList(this.lockingTransactions);
    }
}

