/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.IterableWrapper;

public abstract class AbstractTraverser
implements Traverser {
    TraversalMetadata lastIterator;

    @Override
    public Iterable<Node> nodes() {
        return new IterableWrapper<Node, Path>((Iterable)this){

            @Override
            protected Node underlyingObjectToObject(Path position) {
                return position.endNode();
            }
        };
    }

    @Override
    public Iterable<Relationship> relationships() {
        return new IterableWrapper<Relationship, Path>((Iterable)this){

            @Override
            public Iterator<Relationship> iterator() {
                Iterator<Relationship> iter = super.iterator();
                if (iter.hasNext()) {
                    Relationship first = (Relationship)iter.next();
                    if (first == null) {
                        return iter;
                    }
                    return new CombiningIterator<Relationship>(first, iter);
                }
                return iter;
            }

            @Override
            protected Relationship underlyingObjectToObject(Path position) {
                return position.lastRelationship();
            }
        };
    }

    @Override
    public Iterator<Path> iterator() {
        Iterator<Path> iterator = this.instantiateIterator();
        this.lastIterator = (TraversalMetadata)((Object)iterator);
        return iterator;
    }

    protected abstract Iterator<Path> instantiateIterator();

    @Override
    public TraversalMetadata metadata() {
        return this.lastIterator;
    }
}

