/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class LabelTokenStore
extends TokenStore<LabelTokenRecord> {
    public static final String TYPE_DESCRIPTOR = "LabelTokenStore";
    private static final int RECORD_SIZE = 5;

    public LabelTokenStore(File fileName, Config config, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore) {
        super(fileName, config, IdType.LABEL_TOKEN, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, nameStore);
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, LabelTokenRecord record) throws FAILURE {
        processor.processLabelName(this, record);
    }

    @Override
    protected LabelTokenRecord newRecord(int id) {
        return new LabelTokenRecord(id);
    }

    @Override
    protected void readRecord(LabelTokenRecord record, Buffer buffer) {
        record.setNameId(buffer.getInt());
    }

    @Override
    protected void writeRecord(LabelTokenRecord record, Buffer buffer) {
        buffer.putInt(record.getNameId());
    }

    @Override
    public int getRecordSize() {
        return 5;
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static abstract class Configuration
    extends TokenStore.Configuration {
    }
}

