/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.ThreadToStatementContextBridge;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.transaction.LockType;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge statementCtxProvider;

    RelationshipProxy(long relId, RelationshipLookups relationshipLookups, ThreadToStatementContextBridge statementCtxProvider) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
        this.statementCtxProvider = statementCtxProvider;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).delete(this.relationshipLookups.getNodeManager(), this);
    }

    @Override
    public Node[] getNodes() {
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(relationship.getStartNodeId()), this.relationshipLookups.newNodeProxy(relationship.getEndNodeId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        RelationshipImpl relationship = this.relationshipLookups.lookupRelationship(this.relId);
        if (relationship.getStartNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getEndNodeId());
        }
        if (relationship.getEndNodeId() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(relationship.getStartNodeId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getStartNodeId());
    }

    @Override
    public Node getEndNode() {
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.lookupRelationship(this.relId).getEndNodeId());
    }

    @Override
    public RelationshipType getType() {
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        final StatementContext context = this.statementCtxProvider.getCtxForReading();
        try {
            Set<String> set = IteratorUtil.asSet(Iterables.map(new Function<Long, String>(){

                @Override
                public String apply(Long aLong) {
                    try {
                        return context.propertyKeyGetName(aLong);
                    }
                    catch (PropertyKeyIdNotFoundException e) {
                        throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
                    }
                }
            }, context.relationshipGetPropertyKeys(this.getId())));
            return set;
        }
        finally {
            context.close();
        }
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.relationshipLookups.lookupRelationship(this.relId).getPropertyValues(this.relationshipLookups.getNodeManager());
    }

    @Override
    public Object getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null is not a valid property key.");
        }
        return this.relationshipLookups.lookupRelationship(this.relId).getProperty(this.relationshipLookups.getNodeManager(), key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.relationshipLookups.lookupRelationship(this.relId).getProperty(this.relationshipLookups.getNodeManager(), key, defaultValue);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.relationshipLookups.lookupRelationship(this.relId).hasProperty(this.relationshipLookups.getNodeManager(), key);
    }

    @Override
    public void setProperty(String key, Object property) {
        this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).setProperty(this.relationshipLookups.getNodeManager(), this, key, property);
    }

    @Override
    public Object removeProperty(String key) {
        return this.relationshipLookups.lookupRelationship(this.relId, LockType.WRITE).removeProperty(this.relationshipLookups.getNodeManager(), this, key);
    }

    @Override
    public boolean isType(RelationshipType type) {
        try {
            return this.relationshipLookups.getNodeManager().getRelationshipTypeById(this.relationshipLookups.lookupRelationship(this.relId).getTypeId()).name().equals(type.name());
        }
        catch (TokenNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    public static interface RelationshipLookups {
        public Node newNodeProxy(long var1);

        public RelationshipImpl lookupRelationship(long var1);

        public GraphDatabaseService getGraphDatabaseService();

        public NodeManager getNodeManager();

        public RelationshipImpl lookupRelationship(long var1, LockType var3);
    }
}

