/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.SchemaStorage;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.transaction.LockType;

public class StoreStatementContext
extends CompositeStatementContext {
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final NodeManager nodeManager;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final IndexReaderFactory indexReaderFactory;
    private final NodeStore nodeStore;
    private final Function<String, Long> propertyStringToId = new Function<String, Long>(){

        @Override
        public Long apply(String s) {
            try {
                return StoreStatementContext.this.propertyKeyGetForName(s);
            }
            catch (PropertyKeyNotFoundException e) {
                throw new ThisShouldNotHappenError("Jake", "Property key id stored in store should exist.");
            }
        }
    };
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        @Override
        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final SchemaStorage schemaStorage;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public StoreStatementContext(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, NodeManager nodeManager, SchemaStorage schemaStorage, NeoStore neoStore, IndexingService indexService, IndexReaderFactory indexReaderFactory) {
        this.schemaStorage = schemaStorage;
        assert (neoStore != null) : "No neoStore provided";
        this.indexService = indexService;
        this.indexReaderFactory = indexReaderFactory;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.nodeManager = nodeManager;
        this.neoStore = neoStore;
        this.nodeStore = neoStore.getNodeStore();
    }

    @Override
    protected void beforeWriteOperation() {
        throw new UnsupportedOperationException("The storage layer can not be written to directly, you have to go through a transaction.");
    }

    @Override
    public void close() {
        this.indexReaderFactory.close();
    }

    @Override
    public long labelGetOrCreateForName(String label) throws SchemaKernelException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() != null && e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public long labelGetForName(String label) throws LabelNotFoundKernelException {
        try {
            return this.labelTokenHolder.getIdByName(label);
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException(label, e);
        }
    }

    @Override
    public boolean nodeHasLabel(long nodeId, long labelId) {
        try {
            return IteratorUtil.contains(this.nodeGetLabels(nodeId), labelId);
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public Iterator<Long> nodeGetLabels(long nodeId) {
        try {
            return IteratorUtil.asIterator(this.nodeStore.getLabelsForNode(this.nodeStore.getRecord(nodeId)));
        }
        catch (InvalidRecordException e) {
            return IteratorUtil.emptyIterator();
        }
    }

    @Override
    public String labelGetName(long labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById((int)labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public Iterator<Long> nodesGetForLabel(final long labelId) {
        final NodeStore nodeStore = this.neoStore.getNodeStore();
        final long highestId = nodeStore.getHighestPossibleIdInUse();
        return new PrefetchingIterator<Long>(){
            private long id = 0L;

            @Override
            protected Long fetchNextOrNull() {
                while (this.id <= highestId) {
                    NodeRecord node;
                    if (!(node = nodeStore.forceGetRecord(this.id++)).inUse()) continue;
                    for (long label : nodeStore.getLabelsForNode(node)) {
                        if (label != labelId) continue;
                        return node.getId();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        return StoreStatementContext.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementContext.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        return this.getIndexDescriptorsFor(StoreStatementContext.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final long labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAll());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            @Override
            public IndexDescriptor apply(SchemaRule from) {
                return StoreStatementContext.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getProxyForRule(this.indexId(descriptor)).getState();
    }

    private long indexId(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        try {
            return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IndexNotFoundKernelException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(long labelId, final long propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(long labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    @Override
    public long propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public long propertyKeyGetForName(String propertyKey) throws PropertyKeyNotFoundException {
        try {
            return this.propertyKeyTokenHolder.getIdByName(propertyKey);
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyNotFoundException(propertyKey, e);
        }
    }

    @Override
    public String propertyKeyGetName(long propertyKeyId) throws PropertyKeyIdNotFoundException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById((int)propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundException(propertyKeyId, e);
        }
    }

    @Override
    public Iterator<Long> nodeGetPropertyKeys(long nodeId) {
        return Iterables.map(this.propertyStringToId, this.nodeManager.getNodeForProxy(nodeId, null).getPropertyKeys(this.nodeManager).iterator());
    }

    @Override
    public Iterator<Long> relationshipGetPropertyKeys(long relId) {
        return Iterables.map(this.propertyStringToId, this.nodeManager.getRelationshipForProxy(relId, null).getPropertyKeys(this.nodeManager).iterator());
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            return this.property(propertyKeyId, this.nodeManager.getRelationshipForProxy(relationshipId, null));
        }
        catch (NotFoundException e) {
            throw new EntityNotFoundException("relationship", relationshipId, e);
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("relationship", relationshipId, e);
        }
    }

    @Override
    public Property nodeGetProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            return this.property(propertyKeyId, this.nodeManager.getNodeForProxy(nodeId, null));
        }
        catch (NotFoundException e) {
            throw new EntityNotFoundException("node", nodeId, e);
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("node", nodeId, e);
        }
    }

    private Property property(long propertyKeyId, Primitive primitive) {
        try {
            return Property.property(propertyKeyId, primitive.getProperty(this.nodeManager, (int)propertyKeyId));
        }
        catch (NotFoundException e) {
            return Property.none(propertyKeyId);
        }
    }

    @Override
    public boolean nodeHasProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            String propertyKey = this.propertyKeyGetName(propertyKeyId);
            return this.nodeManager.getNodeForProxy(nodeId, null).hasProperty(this.nodeManager, propertyKey);
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("node", nodeId, e);
        }
    }

    @Override
    public void nodeSetProperty(long nodeId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            String propertyKey = this.propertyKeyGetName(property.propertyKeyId());
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId, LockType.WRITE);
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(nodeId);
            nodeImpl.setProperty(this.nodeManager, nodeProxy, propertyKey, property.value());
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("node", nodeId, e);
        }
        catch (PropertyNotFoundException e) {
            throw new IllegalArgumentException("Property used for setting should not be NoProperty", e);
        }
    }

    @Override
    public void relationshipSetProperty(long relationshipId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            String propertyKey = this.propertyKeyGetName(property.propertyKeyId());
            RelationshipImpl relImpl = this.nodeManager.getRelationshipForProxy(relationshipId, LockType.WRITE);
            RelationshipProxy relProxy = this.nodeManager.newRelationshipProxyById(relationshipId);
            relImpl.setProperty(this.nodeManager, relProxy, propertyKey, property.value());
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("relationship", relationshipId, e);
        }
        catch (PropertyNotFoundException e) {
            throw new IllegalArgumentException("Property used for setting should not be NoProperty", e);
        }
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        try {
            String propertyKey = this.propertyKeyGetName(propertyKeyId);
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId, LockType.WRITE);
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(nodeId);
            Object value = nodeImpl.removeProperty(this.nodeManager, nodeProxy, propertyKey);
            return value == null ? Property.none(propertyKeyId) : Property.property(propertyKeyId, value);
        }
        catch (IllegalStateException e) {
            throw new EntityNotFoundException("node", nodeId, e);
        }
    }

    @Override
    public Iterator<Long> nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.indexReaderFactory.newReader(this.indexId(index)).lookup(value);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        throw new UnsupportedOperationException("Schema state is not handled by the stores");
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        throw new UnsupportedOperationException("Schema state is not handled by the stores");
    }
}

