/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.impl.api.InteractionStoppingStatementContext;

public abstract class StatementContextOwner {
    private ReferencedStatementContext reference;

    public StatementContext getStatementContext() {
        if (this.reference == null) {
            this.reference = new ReferencedStatementContext(this.createStatementContext());
        }
        return this.reference.new ReferencedStatementContext.StatementContextReference();
    }

    protected abstract StatementContext createStatementContext();

    public void closeAllStatements() {
        if (this.reference != null) {
            this.reference.close();
            this.reference = null;
        }
    }

    private class ReferencedStatementContext {
        private int count;
        private final StatementContext statementContext;

        ReferencedStatementContext(StatementContext statementContext) {
            this.statementContext = statementContext;
        }

        void close() {
            if (this.count > 0) {
                this.statementContext.close();
                StatementContextOwner.this.reference = null;
            }
            this.count = 0;
        }

        class StatementContextReference
        extends InteractionStoppingStatementContext {
            private boolean open;

            StatementContextReference() {
                super(ReferencedStatementContext.this.statementContext);
                this.open = true;
                ReferencedStatementContext.this.count++;
            }

            @Override
            protected void markAsClosed() {
                this.open = false;
                ReferencedStatementContext.this.count--;
                if (ReferencedStatementContext.this.count == 0) {
                    ReferencedStatementContext.this.statementContext.close();
                    StatementContextOwner.this.reference = null;
                }
            }

            @Override
            public boolean isOpen() {
                return this.open && ReferencedStatementContext.this.count > 0;
            }

            @Override
            protected void doClose() {
            }
        }
    }
}

