/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.Closeable;
import java.util.Iterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyKeyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.operations.EntityOperations;
import org.neo4j.kernel.api.operations.KeyOperations;
import org.neo4j.kernel.api.operations.SchemaOperations;
import org.neo4j.kernel.api.operations.SchemaStateOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.ConstraintCreationKernelException;
import org.neo4j.kernel.impl.api.UnsupportiveStatementContext;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.Token;

public class CompositeStatementContext
implements StatementContext {
    private final KeyOperations keyOperations;
    private final EntityOperations entityOperations;
    private final SchemaOperations schemaOperations;
    private final SchemaStateOperations schemaStateOperations;
    private final Closeable delegateToClose;

    public CompositeStatementContext() {
        this(UnsupportiveStatementContext.instance());
    }

    public CompositeStatementContext(StatementContext delegate) {
        this(delegate, delegate, delegate, delegate, delegate);
    }

    public CompositeStatementContext(StatementContext delegate, SchemaStateOperations schemaStateOperations) {
        this(delegate, delegate, delegate, schemaStateOperations, delegate);
    }

    public CompositeStatementContext(StatementContext delegate, SchemaOperations schemaOperations) {
        this(delegate, delegate, schemaOperations, delegate, delegate);
    }

    private CompositeStatementContext(KeyOperations keyOperations, EntityOperations entityOperations, SchemaOperations schemaOperations, SchemaStateOperations schemaStateOperations, Closeable delegateToClose) {
        this.keyOperations = keyOperations;
        this.entityOperations = entityOperations;
        this.schemaOperations = schemaOperations;
        this.schemaStateOperations = schemaStateOperations;
        this.delegateToClose = delegateToClose;
    }

    protected void beforeOperation() {
    }

    protected void afterOperation() {
    }

    protected void beforeReadOperation() {
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
    }

    protected void afterWriteOperation() {
    }

    @Override
    public void close() {
        if (this.delegateToClose != null) {
            try {
                this.delegateToClose.close();
            }
            catch (Exception e) {
                throw Exceptions.launderedException("Failed to close " + this, (Throwable)e);
            }
        } else {
            throw new IllegalStateException("Asked to close, but was not given a full implementation of statement context. Please either override this close method, or give CompositeStatementContext a full implementation of the statement context interface.");
        }
    }

    @Override
    public <K> boolean schemaStateContains(K key) {
        this.beforeOperation();
        boolean result = this.schemaStateOperations.schemaStateContains(key);
        this.afterOperation();
        return result;
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        this.beforeOperation();
        V result = this.schemaStateOperations.schemaStateGetOrCreate(key, creator);
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> nodesGetForLabel(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.nodesGetForLabel(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> nodesGetFromIndexLookup(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.nodesGetFromIndexLookup(index, value);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long labelGetForName(String label) throws LabelNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        long result = this.keyOperations.labelGetForName(label);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public String labelGetName(long labelId) throws LabelNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        String result = this.keyOperations.labelGetName(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean nodeHasLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        boolean result = this.entityOperations.nodeHasLabel(nodeId, labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.nodeGetLabels(nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long propertyKeyGetForName(String propertyKey) throws PropertyKeyNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        long result = this.keyOperations.propertyKeyGetForName(propertyKey);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public String propertyKeyGetName(long propertyKeyId) throws PropertyKeyIdNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        String result = this.keyOperations.propertyKeyGetName(propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Property nodeGetProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Property result = this.entityOperations.nodeGetProperty(nodeId, propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Property result = this.entityOperations.relationshipGetProperty(relationshipId, propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean nodeHasProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        boolean result = this.entityOperations.nodeHasProperty(nodeId, propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean relationshipHasProperty(long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        boolean result = this.entityOperations.relationshipHasProperty(relationshipId, propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> nodeGetPropertyKeys(long nodeId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.nodeGetPropertyKeys(nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Property> nodeGetAllProperties(long nodeId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Property> result = this.entityOperations.nodeGetAllProperties(nodeId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Long> relationshipGetPropertyKeys(long relationshipId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Long> result = this.entityOperations.relationshipGetPropertyKeys(relationshipId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Property> relationshipGetAllProperties(long relationshipId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Property> result = this.entityOperations.relationshipGetAllProperties(relationshipId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(long labelId, long propertyKey) throws SchemaRuleNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        IndexDescriptor result = this.schemaOperations.indexesGetForLabelAndPropertyKey(labelId, propertyKey);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexDescriptor> result = this.schemaOperations.indexesGetForLabel(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexDescriptor> result = this.schemaOperations.indexesGetAll();
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexDescriptor> result = this.schemaOperations.uniqueIndexesGetForLabel(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<IndexDescriptor> result = this.schemaOperations.uniqueIndexesGetAll();
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.beforeOperation();
        this.beforeReadOperation();
        InternalIndexState result = this.schemaOperations.indexGetState(descriptor);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(long labelId, long propertyKeyId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<UniquenessConstraint> result = this.schemaOperations.constraintsGetForLabelAndPropertyKey(labelId, propertyKeyId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(long labelId) {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<UniquenessConstraint> result = this.schemaOperations.constraintsGetForLabel(labelId);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        Long result = this.schemaOperations.indexGetOwningUniquenessConstraintId(index);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.beforeOperation();
        this.beforeReadOperation();
        long result = this.schemaOperations.indexGetCommittedId(index);
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<UniquenessConstraint> result = this.schemaOperations.constraintsGetAll();
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.beforeOperation();
        this.beforeReadOperation();
        Iterator<Token> result = this.keyOperations.labelsGetAllTokens();
        this.afterReadOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long labelGetOrCreateForName(String label) throws SchemaKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        long result = this.keyOperations.labelGetOrCreateForName(label);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean nodeAddLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        boolean result = this.entityOperations.nodeAddLabel(nodeId, labelId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, long labelId) throws EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        boolean result = this.entityOperations.nodeRemoveLabel(nodeId, labelId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public long propertyKeyGetOrCreateForName(String propertyKey) throws SchemaKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        long result = this.keyOperations.propertyKeyGetOrCreateForName(propertyKey);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexDescriptor indexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        IndexDescriptor result = this.schemaOperations.indexCreate(labelId, propertyKey);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public IndexDescriptor uniqueIndexCreate(long labelId, long propertyKey) throws SchemaKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        IndexDescriptor result = this.schemaOperations.uniqueIndexCreate(labelId, propertyKey);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(long labelId, long propertyKeyId) throws SchemaKernelException, ConstraintCreationKernelException {
        this.beforeOperation();
        this.beforeWriteOperation();
        UniquenessConstraint result = this.schemaOperations.uniquenessConstraintCreate(labelId, propertyKeyId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public void constraintDrop(UniquenessConstraint constraint) {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.schemaOperations.constraintDrop(constraint);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.schemaOperations.indexDrop(descriptor);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.schemaOperations.uniqueIndexDrop(descriptor);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public void nodeSetProperty(long nodeId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.entityOperations.nodeSetProperty(nodeId, property);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public void relationshipSetProperty(long relationshipId, Property property) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.entityOperations.relationshipSetProperty(relationshipId, property);
        this.afterWriteOperation();
        this.afterOperation();
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        Property result = this.entityOperations.nodeRemoveProperty(nodeId, propertyKeyId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public Property relationshipRemoveProperty(long relationshipId, long propertyKeyId) throws PropertyKeyIdNotFoundException, EntityNotFoundException {
        this.beforeOperation();
        this.beforeWriteOperation();
        Property result = this.entityOperations.relationshipRemoveProperty(relationshipId, propertyKeyId);
        this.afterWriteOperation();
        this.afterOperation();
        return result;
    }

    @Override
    public void nodeDelete(long nodeId) {
        this.beforeOperation();
        this.beforeWriteOperation();
        this.entityOperations.nodeDelete(nodeId);
        this.afterWriteOperation();
        this.afterOperation();
    }
}

